/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.TestDatabaseModule;
import de.comhix.twitch.database.dao.BaseDao;
import de.comhix.twitch.database.dao.Query;
import de.comhix.twitch.database.dao.QueryTest;
import de.comhix.twitch.database.dao.TypeDao;
import de.comhix.twitch.database.objects.DatabaseObject;
import de.comhix.twitch.database.objects.TestObject;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.mongodb.morphia.Datastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestDatabaseModule.class})
public class TypeDaoTest
extends QueryTest {
    private static final Logger log = LoggerFactory.getLogger(TypeDaoTest.class);
    @Inject
    private Datastore datastore;
    private TypeDao<TestObject> typeDao;

    @BeforeMethod
    public void setup() {
        this.typeDao = new TypeDao(new BaseDao(this.datastore), TestObject.class);
    }

    @Test(timeOut=30000L)
    public void testSave() throws Exception {
        log.info("testSave_own");
        TestObject user1 = new TestObject();
        user1.authToken = "bla";
        this.typeDao.save((DatabaseObject)user1).blockingGet();
        TestObject saved = (TestObject)((Object)this.datastore.get(TestObject.class, (Object)user1.id));
        Assertions.assertThat((Object)((Object)saved)).isNotNull();
        Assertions.assertThat((String)saved.authToken).isEqualTo((Object)user1.authToken);
    }

    @Test(timeOut=30000L)
    public void testGet() throws Exception {
        log.info("testGet");
        TestObject user1 = new TestObject();
        user1.authToken = "bla";
        this.typeDao.save((DatabaseObject)user1).blockingGet();
        TestObject saved = (TestObject)((Object)this.typeDao.get(user1.id).blockingGet());
        Assertions.assertThat((String)saved.authToken).isEqualTo((Object)user1.authToken);
    }

    @Test(timeOut=30000L)
    public void testDelete() throws Exception {
        log.info("testDelete");
        TestObject user1 = new TestObject();
        user1.authToken = "bla";
        this.typeDao.save((DatabaseObject)user1).blockingGet();
        this.typeDao.delete(user1.id).blockingAwait();
        Boolean notExisting = (Boolean)this.typeDao.get(user1.id).isEmpty().blockingGet();
        Assertions.assertThat((Boolean)notExisting).isTrue();
    }

    @Override
    protected Query<TestObject> queryProvider() {
        return this.typeDao.query();
    }
}

