package de.comhix.twitch.database.objects;

import com.google.common.collect.ForwardingList;

import java.util.List;

/**
 * @author Benjamin Beeker
 */
public class QueryResult<Type> extends ForwardingList<Type> {

    private final List<Type> objects;
    private final long count;

    public QueryResult(List<Type> objects) {
        this(objects, objects.size());
    }

    public QueryResult(List<Type> objects, long count) {
        this.objects = objects;
        this.count = count;
    }

    /**
     * The total number of matching objects found in the database for this query
     *
     * @return matching objects count
     * @since 1.4.7
     */
    public long getCount() {
        return count;
    }

    @Override
    protected List<Type> delegate() {
        return objects;
    }
}
