package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.objects.DatabaseObject;
import io.reactivex.Completable;
import io.reactivex.Observable;

import java.util.Optional;

/**
 * @author Benjamin Beeker
 */
public interface SimpleTypeDao<ObjectBase extends DatabaseObject> {
    <Type extends ObjectBase> Observable<Optional<Type>> get(String id);

    <Type extends ObjectBase> Observable<Type> save(Type object);

    Completable delete(String id);

    <Type extends ObjectBase> Query<Type> query();
}
