package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.objects.DatabaseObject;
import io.reactivex.Completable;
import io.reactivex.Observable;

import java.util.Optional;

/**
 * @author Benjamin Beeker
 */
public interface SimpleDao<ObjectBase extends DatabaseObject> {
    <Type extends ObjectBase> Observable<Optional<Type>> get(String id, Class<Type> typeClass);

    <Type extends ObjectBase> Observable<Type> save(Type object);

    <Type extends ObjectBase> Completable delete(String id, Class<Type> typeClass);

    <Type extends ObjectBase> Query<Type> query(Class<Type> typeClass);
}
