/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.TestDatabaseModule;
import de.comhix.twitch.database.dao.Query;
import de.comhix.twitch.database.objects.TestObject;
import java.util.List;
import javax.inject.Inject;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.mongodb.morphia.Datastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestDatabaseModule.class})
public class QueryTest {
    private static final Logger log = LoggerFactory.getLogger(QueryTest.class);
    @Inject
    private Datastore datastore;

    @BeforeMethod
    public void cleanup() {
        this.datastore.getDB().dropDatabase();
    }

    @Test(timeOut=30000L)
    public void testSimpleQuery() throws Exception {
        log.info("testSimpleQuery");
        TestObject user1 = new TestObject();
        user1.authToken = "bla";
        TestObject user2 = new TestObject();
        user2.authToken = "authToken";
        this.datastore.save((Object)user1);
        this.datastore.save((Object)user2);
        Query<TestObject> query = this.queryProvider();
        query.with("authToken", Query.Operation.EQ, (Object)"authToken");
        List queryList = (List)query.query().blockingFirst();
        ((AbstractListAssert)Assertions.assertThat((List)queryList).usingFieldByFieldElementComparator()).containsOnly((Object[])new TestObject[]{user2});
    }

    @Test(timeOut=30000L)
    public void testLimitQuery() throws Exception {
        log.info("testLimitQuery");
        TestObject user1 = new TestObject();
        TestObject user2 = new TestObject();
        TestObject user3 = new TestObject();
        this.datastore.save((Object)user1);
        this.datastore.save((Object)user2);
        this.datastore.save((Object)user3);
        Query<TestObject> query = this.queryProvider();
        query.limit(2);
        List queryList = (List)query.query().blockingFirst();
        ((AbstractListAssert)Assertions.assertThat((List)queryList).usingFieldByFieldElementComparator()).containsOnly((Object[])new TestObject[]{user1, user2});
    }

    protected Query<TestObject> queryProvider() {
        return new Query(TestObject.class, this.datastore);
    }
}

