package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.objects.UserDatabaseObject;
import io.reactivex.Completable;
import io.reactivex.Observable;

import java.util.Optional;

/**
 * @author Benjamin Beeker
 */
public class TypeUserDao<Type extends UserDatabaseObject> implements SimpleTypeDao<Type> {

    private final UserDao userDao;
    private final Class<Type> typeClass;

    public TypeUserDao(UserDao userDao, Class<Type> typeClass) {
        this.userDao = userDao;
        this.typeClass = typeClass;
    }

    @Override
    public Observable<Optional<Type>> get(String id) {
        return userDao.get(id, typeClass);
    }

    @Override
    public <MType extends Type> Observable<MType> save(MType object) {
        return userDao.save(object);
    }

    @Override
    public Completable delete(String id) {
        return userDao.delete(id, typeClass);
    }

    @Override
    public Query<Type> query() {
        return userDao.query(typeClass);
    }
}
