package de.comhix.twitch.database.config;

import com.google.inject.AbstractModule;
import com.mongodb.MongoClient;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;

/**
 * @author Benjamin Beeker
 */
public class DatabaseModule extends AbstractModule {
    protected final String host;
    protected final int port;
    private final String dbName;

    public DatabaseModule(String host, int port, String dbName) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
    }

    @Override
    protected void configure() {
        MongoClient mongo = new MongoClient(host, port);
        Datastore datastore = new Morphia().createDatastore(mongo, dbName);
        bind(Datastore.class).toInstance(datastore);
    }
}
