package de.comhix.commons.logging

import java.util.logging.Level
import java.util.logging.Level.*
import java.util.logging.Logger
import kotlin.reflect.KClass

/**
 * @author Benjamin Beeker
 */
inline fun <reified Type : Any> Type.info(message: String) {
    logger(Type::class).log(INFO, message)
}

inline fun <reified Type : Any> Type.info(message: String, throwable: Throwable) {
    logger(Type::class).log(INFO, message, throwable)
}

inline fun <reified Type : Any> Type.info(message: String, param: Any) {
    logger(Type::class).log(INFO, message, param)
}

inline fun <reified Type : Any> Type.info(message: String, vararg params: Any) {
    logger(Type::class).log(INFO, message, params)
}

inline fun <reified Type : Any> Type.debug(message: String) {
    logger(Type::class).log(FINE, message)
}

inline fun <reified Type : Any> Type.debug(message: String, throwable: Throwable) {
    logger(Type::class).log(FINE, message, throwable)
}

inline fun <reified Type : Any> Type.debug(message: String, param: Any) {
    logger(Type::class).log(FINE, message, param)
}

inline fun <reified Type : Any> Type.debug(message: String, vararg params: Any) {
    logger(Type::class).log(FINE, message, params)
}

inline fun <reified Type : Any> Type.warn(message: String) {
    logger(Type::class).log(WARNING, message)
}

inline fun <reified Type : Any> Type.warn(message: String, throwable: Throwable) {
    logger(Type::class).log(WARNING, message, throwable)
}

inline fun <reified Type : Any> Type.warn(message: String, param: Any) {
    logger(Type::class).log(WARNING, message, param)
}

inline fun <reified Type : Any> Type.warn(message: String, vararg params: Any) {
    logger(Type::class).log(WARNING, message, params)
}

inline fun <reified Type : Any> Type.error(message: String) {
    logger(Type::class).log(SEVERE, message)
}

inline fun <reified Type : Any> Type.error(message: String, throwable: Throwable) {
    logger(Type::class).log(SEVERE, message, throwable)
}

inline fun <reified Type : Any> Type.error(message: String, param: Any) {
    logger(Type::class).log(SEVERE, message, param)
}

inline fun <reified Type : Any> Type.error(message: String, vararg params: Any) {
    logger(Type::class).log(SEVERE, message, params)
}

inline fun <reified Type : Any> Type.log(level: Level, message: String) {
    logger(Type::class).log(level, message)
}

inline fun <reified Type : Any> Type.log(level: Level, message: String, throwable: Throwable) {
    logger(Type::class).log(level, message, throwable)
}

inline fun <reified Type : Any> Type.log(level: Level, message: String, param: Any) {
    logger(Type::class).log(level, message, param)
}

inline fun <reified Type : Any> Type.log(level: Level, message: String, vararg params: Any) {
    logger(Type::class).log(level, message, params)
}

inline fun <reified Type : Any> Type.logger() = logger(Type::class)

fun logger(klass: KClass<out Any>) = Logger.getLogger(klass.qualifiedName)!!