package de.comhix.commons.logging

import java.util.logging.Level
import java.util.logging.Level.*
import java.util.logging.Logger

/**
 * @author Benjamin Beeker
 */
fun Any.info(message: String) {
    logger().log(INFO, message)
}

fun Any.info(message: String, throwable: Throwable) {
    logger().log(INFO, message, throwable)
}

fun Any.info(message: String, param: Any) {
    logger().log(INFO, message, param)
}

fun Any.info(message: String, vararg params: Any) {
    logger().log(INFO, message, params)
}

fun Any.debug(message: String) {
    logger().log(FINE, message)
}

fun Any.debug(message: String, throwable: Throwable) {
    logger().log(FINE, message, throwable)
}

fun Any.debug(message: String, param: Any) {
    logger().log(FINE, message, param)
}

fun Any.debug(message: String, vararg params: Any) {
    logger().log(FINE, message, params)
}

fun Any.warn(message: String) {
    logger().log(WARNING, message)
}

fun Any.warn(message: String, throwable: Throwable) {
    logger().log(WARNING, message, throwable)
}

fun Any.warn(message: String, param: Any) {
    logger().log(WARNING, message, param)
}

fun Any.warn(message: String, vararg params: Any) {
    logger().log(WARNING, message, params)
}

fun Any.error(message: String) {
    logger().log(SEVERE, message)
}

fun Any.error(message: String, throwable: Throwable) {
    logger().log(SEVERE, message, throwable)
}

fun Any.error(message: String, param: Any) {
    logger().log(SEVERE, message, param)
}

fun Any.error(message: String, vararg params: Any) {
    logger().log(SEVERE, message, params)
}

fun Any.log(level: Level, message: String) {
    logger().log(level, message)
}

fun Any.log(level: Level, message: String, throwable: Throwable) {
    logger().log(level, message, throwable)
}

fun Any.log(level: Level, message: String, param: Any) {
    logger().log(level, message, param)
}

fun Any.log(level: Level, message: String, vararg params: Any) {
    logger().log(level, message, params)
}

fun Throwable.info(message: String? = this.message) {
    logger().log(INFO, message, this)
}

fun Throwable.debug(message: String? = this.message) {
    logger().log(FINE, message, this)
}

fun Throwable.warn(message: String? = this.message) {
    logger().log(WARNING, message, this)
}

fun Throwable.error(message: String? = this.message) {
    logger().log(SEVERE, message, this)
}

fun Throwable.log(level: Level, message: String? = this.message) {
    logger().log(level, message, this)
}

fun Any.logger() = Logger.getLogger(this::class.qualifiedName)!!