/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.commons.logging;

import com.rollbar.notifier.Rollbar;
import com.rollbar.notifier.config.Config;
import com.rollbar.notifier.config.ConfigBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.MDC;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/comhix/commons/logging/RollbarHandler;", "Ljava/util/logging/Handler;", "()V", "apiKey", "", "environment", "rollbar", "Lcom/rollbar/notifier/Rollbar;", "close", "", "configure", "flush", "getProperty", "key", "getRollbar", "publish", "record", "Ljava/util/logging/LogRecord;", "logging"})
public final class RollbarHandler
extends Handler {
    private String apiKey;
    private String environment;
    private Rollbar rollbar;

    private final Rollbar getRollbar() {
        if (this.rollbar == null) {
            this.configure();
            Config config = ConfigBuilder.withAccessToken((String)this.apiKey).environment(this.environment).build();
            this.rollbar = new Rollbar(config);
        }
        return this.rollbar;
    }

    private final void configure() {
        String prexif = this.getClass().getName();
        if (this.apiKey == null) {
            this.apiKey = this.getProperty(prexif + ".apiKey");
        }
        if (this.environment == null) {
            this.environment = this.getProperty(prexif + ".environment");
        }
        this.setFormatter(new Formatter(){

            @NotNull
            public String format(@NotNull LogRecord record) {
                Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                String string = this.formatMessage(record);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatMessage(record)");
                return string;
            }
        });
    }

    private final String getProperty(String key) {
        String string = Optional.ofNullable(System.getProperty(key)).orElse(LogManager.getLogManager().getProperty(key));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Optional.ofNullable(Syst\u2026nager().getProperty(key))");
        return string;
    }

    @Override
    public void publish(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (!this.isLoggable(record)) {
            return;
        }
        com.rollbar.api.payload.data.Level level = record.getLevel() == Level.SEVERE ? com.rollbar.api.payload.data.Level.ERROR : (record.getLevel() == Level.WARNING ? com.rollbar.api.payload.data.Level.WARNING : (record.getLevel() == Level.INFO ? com.rollbar.api.payload.data.Level.INFO : com.rollbar.api.payload.data.Level.DEBUG));
        Map customData = new HashMap();
        customData.put("source", record.getSourceClassName() + "::" + record.getSourceMethodName());
        Map mdcMap = MDC.getCopyOfContextMap();
        if (mdcMap != null) {
            customData.putAll(mdcMap);
        }
        Rollbar rollbar = this.getRollbar();
        Intrinsics.checkNotNull((Object)rollbar);
        rollbar.log(record.getThrown(), customData, this.getFormatter().formatMessage(record), level);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        try {
            Rollbar rollbar = this.getRollbar();
            Intrinsics.checkNotNull((Object)rollbar);
            rollbar.close(true);
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
    }
}

