/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.commons.logging;

import com.rollbar.notifier.Rollbar;
import com.rollbar.notifier.config.Config;
import com.rollbar.notifier.config.ConfigBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.MDC;

public class RollbarHandler
extends Handler {
    private String apiKey;
    private String environment;
    private Rollbar rollbar;

    private Rollbar getRollbar() {
        if (this.rollbar == null) {
            this.configure();
            Config config = ConfigBuilder.withAccessToken((String)this.apiKey).environment(this.environment).build();
            this.rollbar = new Rollbar(config);
        }
        return this.rollbar;
    }

    private void configure() {
        String prexif = this.getClass().getName();
        if (this.apiKey == null) {
            this.apiKey = this.getProperty(prexif + ".apiKey");
        }
        if (this.environment == null) {
            this.environment = this.getProperty(prexif + ".environment");
        }
        this.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return this.formatMessage(record);
            }
        });
    }

    private String getProperty(String key) {
        return Optional.ofNullable(System.getProperty(key)).orElse(LogManager.getLogManager().getProperty(key));
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        com.rollbar.api.payload.data.Level level = record.getLevel() == Level.SEVERE ? com.rollbar.api.payload.data.Level.ERROR : (record.getLevel() == Level.WARNING ? com.rollbar.api.payload.data.Level.WARNING : (record.getLevel() == Level.INFO ? com.rollbar.api.payload.data.Level.INFO : com.rollbar.api.payload.data.Level.DEBUG));
        HashMap<String, String> customData = new HashMap<String, String>();
        customData.put("source", record.getSourceClassName() + "::" + record.getSourceMethodName());
        Map mdcMap = MDC.getCopyOfContextMap();
        if (mdcMap != null) {
            customData.putAll(mdcMap);
        }
        this.getRollbar().log(record.getThrown(), customData, this.getFormatter().formatMessage(record), level);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.getRollbar().close(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

