package de.comhix.commons.logging;

import com.rollbar.api.payload.data.Level;
import com.rollbar.notifier.Rollbar;
import com.rollbar.notifier.config.Config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

import static com.rollbar.notifier.config.ConfigBuilder.withAccessToken;

public class RollbarAppender extends Handler {

    private String apiKey;
    private String environment;
    private Rollbar rollbar;

    private Rollbar getRollbar() {
        if (this.rollbar == null) {
            loadValuesFromProperties();
            Config config = withAccessToken(apiKey).environment(environment).build();
            this.rollbar = new Rollbar(config);
        }
        return this.rollbar;
    }

    private void loadValuesFromProperties() {
        String prexif = this.getClass().getName();
        if (apiKey == null) {
            apiKey = getProperty(prexif + ".apiKey");
        }
        if (environment == null) {
            environment = getProperty(prexif + ".environment");
        }
    }

    private String getProperty(String key) {
        return Optional.ofNullable(System.getProperty(key)).orElse(LogManager.getLogManager().getProperty(key));
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setEnvironment(String environment) {
        this.environment = environment.toLowerCase();
    }

    @Override
    public void publish(LogRecord record) {
        Level level;
        if (record.getLevel() == java.util.logging.Level.SEVERE) {
            level = Level.ERROR;
        }
        else if (record.getLevel() == java.util.logging.Level.WARNING) {
            level = Level.WARNING;
        }
        else if (record.getLevel() == java.util.logging.Level.INFO) {
            level = Level.INFO;
        }
        else {
            level = Level.DEBUG;
        }

        Map<String, Object> customData = new HashMap<>();
        customData.put("source", record.getSourceClassName() + "#" + record.getSourceMethodName());
        getRollbar().log(record.getThrown(), customData, this.getFormatter().formatMessage(record), level);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        try {
            getRollbar().close(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}