/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.commons.logging;

import com.rollbar.notifier.Rollbar;
import com.rollbar.notifier.config.Config;
import com.rollbar.notifier.config.ConfigBuilder;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class RollbarAppender
extends Handler {
    private String apiKey;
    private String environment;
    private Rollbar rollbar;

    private Rollbar getRollbar() {
        if (this.rollbar == null) {
            Config config = ConfigBuilder.withAccessToken((String)this.apiKey).environment(this.environment).build();
            this.rollbar = new Rollbar(config);
        }
        return this.rollbar;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setEnvironment(String environment) {
        this.environment = environment.toLowerCase();
    }

    @Override
    public void publish(LogRecord record) {
        com.rollbar.api.payload.data.Level level = record.getLevel() == Level.SEVERE ? com.rollbar.api.payload.data.Level.ERROR : (record.getLevel() == Level.WARNING ? com.rollbar.api.payload.data.Level.WARNING : (record.getLevel() == Level.INFO ? com.rollbar.api.payload.data.Level.INFO : com.rollbar.api.payload.data.Level.DEBUG));
        HashMap<String, String> customData = new HashMap<String, String>();
        customData.put("source", record.getSourceClassName() + "#" + record.getSourceMethodName());
        this.getRollbar().log(record.getThrown(), customData, this.getFormatter().formatMessage(record), level);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.getRollbar().close(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

