/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.commons.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.rollbar.Rollbar;
import com.rollbar.payload.data.Level;
import java.util.HashMap;
import java.util.Map;

public class RollbarAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String ENV_VAR_APIKEY = "ROLLBAR_LOGBACK_API_KEY";
    private String apiKey;
    private String environment;
    private boolean async = true;
    private Rollbar rollbar;

    private Rollbar getRollbar() {
        if (this.rollbar == null) {
            this.rollbar = new Rollbar(this.apiKey, this.environment);
        }
        return this.rollbar;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setEnvironment(String environment) {
        this.environment = environment.toLowerCase();
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void start() {
        boolean error = false;
        try {
            String environmentApiKey = System.getenv(ENV_VAR_APIKEY);
            if (environmentApiKey != null) {
                this.apiKey = environmentApiKey;
            }
        }
        catch (SecurityException e) {
            this.addWarn("Access to environment variables was denied. (" + e.getMessage() + ")");
        }
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            this.addError("No apiKey set for the appender named [" + this.getName() + "].");
            error = true;
        }
        if (this.environment == null || this.environment.isEmpty()) {
            this.addError("No environment set for the appender named [" + this.getName() + "].");
            error = true;
        }
        if (!error) {
            super.start();
        }
    }

    public void stop() {
        super.stop();
    }

    protected void append(ILoggingEvent event) {
        if (this.async) {
            this.getContext().getExecutorService().submit(() -> this.sendRequest(event));
        } else {
            this.sendRequest(event);
        }
    }

    private void sendRequest(ILoggingEvent event) {
        String message = event.getFormattedMessage();
        Map propertyMap = event.getMDCPropertyMap();
        HashMap<String, String> customMap = new HashMap<String, String>();
        if (propertyMap != null) {
            customMap.putAll(propertyMap);
        }
        if (event.hasCallerData()) {
            StackTraceElement caller = event.getCallerData()[0];
            customMap.put("log-statement", caller.getFileName() + ":" + caller.getLineNumber());
        }
        Throwable throwable = null;
        ThrowableProxy throwableProxy = (ThrowableProxy)event.getThrowableProxy();
        if (throwableProxy != null) {
            throwable = throwableProxy.getThrowable();
        }
        Level level = Level.DEBUG;
        switch (event.getLevel().toString()) {
            case "ERROR": {
                level = Level.ERROR;
                break;
            }
            case "WARN": {
                level = Level.WARNING;
                break;
            }
            case "INFO": {
                level = Level.INFO;
                break;
            }
            case "DEBUG": {
                level = Level.DEBUG;
            }
        }
        if (customMap.isEmpty()) {
            customMap = null;
        }
        this.getRollbar().log(throwable, customMap, message, level);
    }
}

