package de.comhix.commons.kotlin.gson

import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import kotlin.reflect.KClass

/**
 * @author Benjamin Beeker
 */
inline fun <reified Type> Gson.fromJson(json: String): Type {
    val type = object : TypeToken<Type>() {}.type
    return this.fromJson(json, type)
}

inline fun <reified Type : Any> KClass<Type>.fromJson(json: String): Type {
    return Gson().fromJson(json, this.java)
}

fun Any.toJson(): String = Gson().toJson(this)