package de.comhix.web.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Singleton;
import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import java.io.IOException;

/**
 * @author Benjamin Beeker
 */
@Singleton
public class ErrorFilter implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ErrorFilter.class);

    private ErrorHandler errorHandler;

    @com.google.inject.Inject(optional = true)
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse) response;
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            if(!errorHandler.handle((HttpServletRequest)request,httpResponse,t))
            {
            log.error("uncatched Exception {}", t.getMessage(), t);

            httpResponse.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());}
        }
    }

    @Override
    public void destroy() {
    }
}
