package de.comhix.web.auth.internal;

import de.comhix.web.auth.UserProvider;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import java.util.Optional;

/**
 * @author Benjamin Beeker
 */
@Singleton
public class UserProviderImpl implements UserProvider {
    private final Provider<InternalUserProvider> providerProvider;

    @Inject
    public UserProviderImpl(Provider<InternalUserProvider> providerProvider) {
        this.providerProvider = providerProvider;
    }

    @Override
    public Optional<String> getUser() {
        return Optional.ofNullable(providerProvider.get().getUser());
    }

    @Override
    public void setUser(String user) {
        providerProvider.get().setUser(user);
    }
}
