/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.web.auth.internal;

import de.comhix.web.auth.AuthenticationException;
import de.comhix.web.auth.UserProvider;
import de.comhix.web.auth.internal.InternalUserProvider;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class UserProviderImpl
implements UserProvider {
    private final Provider<InternalUserProvider> providerProvider;

    @Inject
    public UserProviderImpl(Provider<InternalUserProvider> providerProvider) {
        this.providerProvider = providerProvider;
    }

    public Optional<String> getUser() {
        return Optional.ofNullable(((InternalUserProvider)this.providerProvider.get()).getUser());
    }

    public String getUserOrFail() {
        return this.getUser().orElseThrow(AuthenticationException::new);
    }

    public void setUser(String user) {
        ((InternalUserProvider)this.providerProvider.get()).setUser(user);
    }
}

