/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.web.filter;

import com.google.common.base.Splitter;
import de.comhix.web.auth.AuthFunction;
import de.comhix.web.auth.AuthenticationException;
import de.comhix.web.auth.UserProvider;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);
    private static final String DEFAULT_TOKEN_COOKIE_NAME = "auth-cookie";
    public static final String TOKEN_COOKIE_NAME_PARAM = "tokenCookieName";
    public static final String NO_AUTH_PARAM = "noAuth";
    private final AuthFunction authFunction;
    private final UserProvider userProvider;
    private List<String> noAuth;
    private String tokenCookieName;

    @Inject
    public AuthFilter(AuthFunction authFunction, UserProvider userProvider) {
        this.authFunction = authFunction;
        this.userProvider = userProvider;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.debug("filter: {}", (Object)filterConfig.getFilterName());
        Enumeration initParameterNames = filterConfig.getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String name = (String)initParameterNames.nextElement();
            log.debug("{}: {}", (Object)name, (Object)filterConfig.getInitParameter(name));
            if (name.equals(NO_AUTH_PARAM)) {
                this.noAuth = Splitter.on((String)",").trimResults().splitToList((CharSequence)filterConfig.getInitParameter(name));
            }
            if (!name.equals(TOKEN_COOKIE_NAME_PARAM)) continue;
            this.tokenCookieName = filterConfig.getInitParameter(name);
        }
        if (this.tokenCookieName == null) {
            this.tokenCookieName = DEFAULT_TOKEN_COOKIE_NAME;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String servletPath = httpRequest.getServletPath();
        this.checkAuth(httpRequest, servletPath);
        chain.doFilter(request, response);
    }

    private void checkAuth(HttpServletRequest httpRequest, String servletPath) {
        if (this.noAuth.contains(servletPath)) {
            log.debug("no auth needed for {}", (Object)servletPath);
            return;
        }
        log.debug("checking auth for path: {}", (Object)servletPath);
        if (httpRequest.getCookies() != null) {
            for (Cookie cookie : httpRequest.getCookies()) {
                if (!cookie.getName().equals(this.tokenCookieName)) continue;
                this.checkCookieToken(cookie);
                return;
            }
        }
        throw new AuthenticationException();
    }

    public void doAuth(HttpServletResponse response, String token) {
        Cookie cookie = new Cookie(this.tokenCookieName, token);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    private void checkCookieToken(Cookie cookie) {
        Optional user = (Optional)this.authFunction.apply((Object)cookie.getValue());
        if (!user.isPresent()) {
            throw new AuthenticationException();
        }
        this.userProvider.setUser((String)user.get());
    }

    public void destroy() {
    }
}

