package de.comhix.web.auth.internal;

import de.comhix.web.auth.AuthenticationException;
import de.comhix.web.auth.UserProvider;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import java.util.Optional;

/**
 * @author Benjamin Beeker
 */
@Singleton
public class UserProviderImpl implements UserProvider {
    private final Provider<InternalUserProvider> providerProvider;

    @Inject
    public UserProviderImpl(Provider<InternalUserProvider> providerProvider) {
        this.providerProvider = providerProvider;
    }

    public Optional<String> getUser() {
        return Optional.ofNullable(providerProvider.get().getUser());
    }

    @Override
    public String getUserOrFail() {
        return getUser().orElseThrow(AuthenticationException::new);
    }

    public void setUser(String user) {
        providerProvider.get().setUser(user);
    }
}
