/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.web.filter;

import com.google.inject.Inject;
import de.comhix.web.filter.ErrorHandler;
import java.io.IOException;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ErrorFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ErrorFilter.class);
    private ErrorHandler errorHandler;

    @Inject(optional=true)
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block2: {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            try {
                chain.doFilter(request, response);
            }
            catch (Throwable t) {
                if (this.errorHandler.handle((HttpServletRequest)request, httpResponse, t)) break block2;
                log.error("uncatched Exception {}", (Object)t.getMessage(), (Object)t);
                httpResponse.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            }
        }
    }

    public void destroy() {
    }
}

