/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.gradle.plugin;

import de.comahe.i18n4k.generator.GenerationTargetPlatform;
import de.comahe.i18n4k.gradle.plugin.AndroidSupport;
import de.comahe.i18n4k.gradle.plugin.ClearI18n4kFilesTask;
import de.comahe.i18n4k.gradle.plugin.ConstantsKt;
import de.comahe.i18n4k.gradle.plugin.GenerateI18n4kFilesTask;
import de.comahe.i18n4k.gradle.plugin.I18n4kExtension;
import de.comahe.i18n4k.gradle.plugin.I18n4kPlugin;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/comahe/i18n4k/gradle/plugin/I18n4kPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "config", "Lde/comahe/i18n4k/gradle/plugin/I18n4kExtension;", "addDirectoryToSourceDirectorySet", "", "sourceDirectorySet", "Lorg/gradle/api/file/SourceDirectorySet;", "directory", "Ljava/io/File;", "addGeneratedLanguageFilesDirectoryToResources", "project", "addGeneratedSourcesDirectoryToSourceSets", "addNeededPlugins", "addTaskDependencies", "apply", "defineTasks", "findSourceDirectorySet", "type", "Lde/comahe/i18n4k/gradle/plugin/I18n4kPlugin$SourceDirectoryType;", "markGeneratedSourcesDirectoryAsGeneratedInIde", "ideaModel", "Lorg/gradle/plugins/ide/idea/model/IdeaModel;", "Companion", "SourceDirectoryType", "i18n4k-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nI18n4kPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 I18n4kPlugin.kt\nde/comahe/i18n4k/gradle/plugin/I18n4kPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1855#2,2:270\n1855#2,2:272\n*S KotlinDebug\n*F\n+ 1 I18n4kPlugin.kt\nde/comahe/i18n4k/gradle/plugin/I18n4kPlugin\n*L\n167#1:270,2\n225#1:272,2\n*E\n"})
public class I18n4kPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private I18n4kExtension config;

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConstantsKt.getLogger().info("Applying i18n4k plugin...");
        Object object = project.getExtensions().create("i18n4k", I18n4kExtension.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.config = (I18n4kExtension)object;
        I18n4kExtension i18n4kExtension = this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            i18n4kExtension = null;
        }
        if (i18n4kExtension.getGenerationTargetPlatform() == null) {
            GenerationTargetPlatform generationTargetPlatform;
            I18n4kExtension i18n4kExtension2 = this.config;
            if (i18n4kExtension2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                i18n4kExtension2 = null;
            }
            if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
                generationTargetPlatform = GenerationTargetPlatform.MULTI_PLATFORM;
            } else if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.js")) {
                generationTargetPlatform = GenerationTargetPlatform.JS;
            } else if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.native")) {
                generationTargetPlatform = GenerationTargetPlatform.NATIVE;
            } else if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm")) {
                generationTargetPlatform = GenerationTargetPlatform.JVM;
            } else if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.android")) {
                generationTargetPlatform = GenerationTargetPlatform.ANDROID;
            } else {
                throw new IllegalStateException("No of the supported Kotlin-Plugins (multiplatform, js, native, jvm, android) has be applied to the project.\nPlugins: " + project.getPlugins());
            }
            i18n4kExtension2.setGenerationTargetPlatform(generationTargetPlatform);
        }
        this.addNeededPlugins(project);
        this.defineTasks(project);
        project.afterEvaluate(arg_0 -> I18n4kPlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(this, project){
            final /* synthetic */ I18n4kPlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(Project it) {
                I18n4kPlugin.access$addTaskDependencies(this.this$0, this.$project);
            }
        }, arg_0));
        this.addGeneratedSourcesDirectoryToSourceSets(project);
        this.addGeneratedLanguageFilesDirectoryToResources(project);
        this.markGeneratedSourcesDirectoryAsGeneratedInIde(project, (IdeaModel)project.getExtensions().findByType(IdeaModel.class));
        project.getPlugins().withType(IdeaPlugin.class, arg_0 -> I18n4kPlugin.apply$lambda$1((Function1)new Function1<IdeaPlugin, Unit>(this, project){
            final /* synthetic */ I18n4kPlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(IdeaPlugin it) {
                I18n4kPlugin.access$markGeneratedSourcesDirectoryAsGeneratedInIde(this.this$0, this.$project, it.getModel());
            }
        }, arg_0));
    }

    private final void addNeededPlugins(Project project) {
        project.getPluginManager().apply("org.gradle.idea");
    }

    private final void defineTasks(Project project) {
        project.getTasks().create("generateI18n4kFiles", GenerateI18n4kFilesTask.class, arg_0 -> I18n4kPlugin.defineTasks$lambda$2((Function1)new Function1<GenerateI18n4kFilesTask, Unit>(this){
            final /* synthetic */ I18n4kPlugin this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(GenerateI18n4kFilesTask it) {
                I18n4kExtension i18n4kExtension = I18n4kPlugin.access$getConfig$p(this.this$0);
                if (i18n4kExtension == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    i18n4kExtension = null;
                }
                it.setConfig(i18n4kExtension);
                it.setDescription("Generate i18n4k files");
                it.setGroup("i18n");
            }
        }, arg_0));
        project.getTasks().create("clearI18n4kFiles", ClearI18n4kFilesTask.class, arg_0 -> I18n4kPlugin.defineTasks$lambda$3((Function1)new Function1<ClearI18n4kFilesTask, Unit>(this){
            final /* synthetic */ I18n4kPlugin this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ClearI18n4kFilesTask it) {
                I18n4kExtension i18n4kExtension = I18n4kPlugin.access$getConfig$p(this.this$0);
                if (i18n4kExtension == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    i18n4kExtension = null;
                }
                it.setConfig(i18n4kExtension);
                it.setDescription("Clear i18n4k files");
                it.setGroup("i18n");
            }
        }, arg_0));
    }

    private final void addTaskDependencies(Project project) {
        project.getTasks().matching(arg_0 -> I18n4kPlugin.addTaskDependencies$lambda$4(addTaskDependencies.1.INSTANCE, arg_0)).configureEach(arg_0 -> I18n4kPlugin.addTaskDependencies$lambda$5(addTaskDependencies.2.INSTANCE, arg_0));
        project.getTasks().withType(KotlinCompile.class).configureEach(arg_0 -> I18n4kPlugin.addTaskDependencies$lambda$6(addTaskDependencies.3.INSTANCE, arg_0));
        project.getTasks().withType(JavaCompile.class).configureEach(arg_0 -> I18n4kPlugin.addTaskDependencies$lambda$7(addTaskDependencies.4.INSTANCE, arg_0));
        project.getTasks().withType(ProcessResources.class).configureEach(arg_0 -> I18n4kPlugin.addTaskDependencies$lambda$8(addTaskDependencies.5.INSTANCE, arg_0));
        project.getTasks().withType(org.gradle.jvm.tasks.Jar.class).configureEach(arg_0 -> I18n4kPlugin.addTaskDependencies$lambda$9(addTaskDependencies.6.INSTANCE, arg_0));
        project.getTasks().withType(Jar.class).configureEach(arg_0 -> I18n4kPlugin.addTaskDependencies$lambda$10(addTaskDependencies.7.INSTANCE, arg_0));
        project.getTasks().matching(arg_0 -> I18n4kPlugin.addTaskDependencies$lambda$11(addTaskDependencies.8.INSTANCE, arg_0)).configureEach(arg_0 -> I18n4kPlugin.addTaskDependencies$lambda$12(addTaskDependencies.9.INSTANCE, arg_0));
    }

    private final SourceDirectorySet findSourceDirectorySet(Project project, SourceDirectoryType type) {
        SourceDirectorySet sourceDirectorySet;
        NamedDomainObjectContainer sourceSets = ((KotlinProjectExtension)project.getExtensions().getByType(KotlinProjectExtension.class)).getSourceSets();
        I18n4kExtension i18n4kExtension = this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            i18n4kExtension = null;
        }
        Object object = sourceSets.getByName(i18n4kExtension.getGenerationTargetPlatform() == GenerationTargetPlatform.MULTI_PLATFORM ? "commonMain" : "main");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet");
        KotlinSourceSet sourceSet = (KotlinSourceSet)object;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                sourceDirectorySet = sourceSet.getKotlin();
                break;
            }
            case 2: {
                sourceDirectorySet = sourceSet.getResources();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sourceDirectorySet;
    }

    private final void addDirectoryToSourceDirectorySet(SourceDirectorySet sourceDirectorySet, File directory) {
        Object[] objectArray = new Object[]{directory};
        sourceDirectorySet.srcDirs(objectArray);
        if (ConstantsKt.getLogger().isDebugEnabled()) {
            Set set = sourceDirectorySet.getSrcDirs();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSrcDirs(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                ConstantsKt.getLogger().debug("{} - {}", (Object)sourceDirectorySet.getName(), (Object)it);
            }
        }
    }

    private final void addGeneratedSourcesDirectoryToSourceSets(Project project) {
        I18n4kExtension i18n4kExtension = this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            i18n4kExtension = null;
        }
        if (i18n4kExtension.getGenerationTargetPlatform() == GenerationTargetPlatform.JVM) {
            Object v = project.getProperties().get("sourceSets");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.gradle.api.tasks.SourceSetContainer");
            SourceSetContainer sourceSets = (SourceSetContainer)v;
            SourceDirectorySet sourceDirectorySet = ((SourceSet)sourceSets.getByName("main")).getJava();
            Intrinsics.checkNotNull((Object)sourceDirectorySet);
            I18n4kExtension i18n4kExtension2 = this.config;
            if (i18n4kExtension2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                i18n4kExtension2 = null;
            }
            this.addDirectoryToSourceDirectorySet(sourceDirectorySet, Companion.getGeneratedSourcesDirectory(project, i18n4kExtension2));
        } else {
            SourceDirectorySet sourceDirectorySet = this.findSourceDirectorySet(project, SourceDirectoryType.KOTLIN);
            ConstantsKt.getLogger().info("Adding i18n4k generated sources directory to source set '" + sourceDirectorySet.getName() + '\'');
            I18n4kExtension i18n4kExtension3 = this.config;
            if (i18n4kExtension3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                i18n4kExtension3 = null;
            }
            this.addDirectoryToSourceDirectorySet(sourceDirectorySet, Companion.getGeneratedSourcesDirectory(project, i18n4kExtension3));
        }
    }

    private final void addGeneratedLanguageFilesDirectoryToResources(Project project) {
        I18n4kExtension i18n4kExtension = this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            i18n4kExtension = null;
        }
        File genResDir = Companion.getGeneratedLanguageFilesDirectory(project, i18n4kExtension);
        genResDir.mkdirs();
        I18n4kExtension i18n4kExtension2 = this.config;
        if (i18n4kExtension2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            i18n4kExtension2 = null;
        }
        if (i18n4kExtension2.getGenerationTargetPlatform() == GenerationTargetPlatform.JVM) {
            Object v = project.getProperties().get("sourceSets");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.gradle.api.tasks.SourceSetContainer");
            SourceSetContainer sourceSets = (SourceSetContainer)v;
            SourceDirectorySet sourceDirectorySet = ((SourceSet)sourceSets.getByName("main")).getResources();
            Intrinsics.checkNotNull((Object)sourceDirectorySet);
            this.addDirectoryToSourceDirectorySet(sourceDirectorySet, genResDir);
        } else {
            I18n4kExtension i18n4kExtension3 = this.config;
            if (i18n4kExtension3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                i18n4kExtension3 = null;
            }
            if (i18n4kExtension3.getGenerationTargetPlatform() == GenerationTargetPlatform.ANDROID) {
                AndroidSupport.INSTANCE.addGeneratedLanguageFilesDirectoryToResources(project, genResDir);
            } else {
                SourceDirectorySet sourceDirectorySet = this.findSourceDirectorySet(project, SourceDirectoryType.RESOURCES);
                ConstantsKt.getLogger().info("Adding i18n4k generated resources directory to source set '" + sourceDirectorySet.getName() + '\'');
                this.addDirectoryToSourceDirectorySet(sourceDirectorySet, genResDir);
            }
        }
    }

    private final void markGeneratedSourcesDirectoryAsGeneratedInIde(Project project, IdeaModel ideaModel) {
        if (ideaModel == null) {
            ConstantsKt.getLogger().warn("Idea model not set? Missing idea plugin?");
            return;
        }
        ConstantsKt.getLogger().info("Mark i18n4k generated sources directory as 'generated' in IDEA");
        Set set = ideaModel.getModule().getGeneratedSourceDirs();
        I18n4kExtension i18n4kExtension = this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            i18n4kExtension = null;
        }
        set.add(Companion.getGeneratedSourcesDirectory(project, i18n4kExtension));
        if (ConstantsKt.getLogger().isDebugEnabled()) {
            Set set2 = ideaModel.getModule().getGeneratedSourceDirs();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getGeneratedSourceDirs(...)");
            Iterable $this$forEach$iv = set2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                ConstantsKt.getLogger().debug("generatedSourceDirs[IDEA] - {}", (Object)it);
            }
        }
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void defineTasks$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void defineTasks$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean addTaskDependencies$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void addTaskDependencies$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addTaskDependencies$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addTaskDependencies$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addTaskDependencies$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addTaskDependencies$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addTaskDependencies$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean addTaskDependencies$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void addTaskDependencies$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$addTaskDependencies(I18n4kPlugin $this, Project project) {
        $this.addTaskDependencies(project);
    }

    public static final /* synthetic */ void access$markGeneratedSourcesDirectoryAsGeneratedInIde(I18n4kPlugin $this, Project project, IdeaModel ideaModel) {
        $this.markGeneratedSourcesDirectoryAsGeneratedInIde(project, ideaModel);
    }

    public static final /* synthetic */ I18n4kExtension access$getConfig$p(I18n4kPlugin $this) {
        return $this.config;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lde/comahe/i18n4k/gradle/plugin/I18n4kPlugin$Companion;", "", "()V", "getGeneratedLanguageFilesDirectory", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "config", "Lde/comahe/i18n4k/gradle/plugin/I18n4kExtension;", "getGeneratedSourcesDirectory", "i18n4k-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getGeneratedSourcesDirectory(@NotNull Project project, @NotNull I18n4kExtension config) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            String string = config.getSourceCodeOutputDirectory();
            String string2 = project.getBuildDir().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            File dir = new File(StringsKt.replace$default((String)string, (String)"{buildDir}", (String)string2, (boolean)false, (int)4, null));
            dir.mkdirs();
            return dir;
        }

        @NotNull
        public final File getGeneratedLanguageFilesDirectory(@NotNull Project project, @NotNull I18n4kExtension config) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            String string = config.getLanguageFilesOutputDirectory();
            String string2 = project.getBuildDir().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            File dir = new File(StringsKt.replace$default((String)string, (String)"{buildDir}", (String)string2, (boolean)false, (int)4, null));
            dir.mkdirs();
            return dir;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lde/comahe/i18n4k/gradle/plugin/I18n4kPlugin$SourceDirectoryType;", "", "(Ljava/lang/String;I)V", "KOTLIN", "RESOURCES", "i18n4k-gradle-plugin"})
    public static final class SourceDirectoryType
    extends Enum<SourceDirectoryType> {
        public static final /* enum */ SourceDirectoryType KOTLIN = new SourceDirectoryType();
        public static final /* enum */ SourceDirectoryType RESOURCES = new SourceDirectoryType();
        private static final /* synthetic */ SourceDirectoryType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SourceDirectoryType[] values() {
            return (SourceDirectoryType[])$VALUES.clone();
        }

        public static SourceDirectoryType valueOf(String value) {
            return Enum.valueOf(SourceDirectoryType.class, value);
        }

        @NotNull
        public static EnumEntries<SourceDirectoryType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sourceDirectoryTypeArray = new SourceDirectoryType[]{SourceDirectoryType.KOTLIN, SourceDirectoryType.RESOURCES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceDirectoryType.values().length];
            try {
                nArray[SourceDirectoryType.KOTLIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceDirectoryType.RESOURCES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

