/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.gradle.plugin;

import de.comahe.i18n4k.generator.GenerationTargetPlatform;
import de.comahe.i18n4k.gradle.plugin.ClearI18n4kFilesTask;
import de.comahe.i18n4k.gradle.plugin.ConstantsKt;
import de.comahe.i18n4k.gradle.plugin.GenerateI18n4kFilesTask;
import de.comahe.i18n4k.gradle.plugin.I18n4kExtension;
import de.comahe.i18n4k.gradle.plugin.I18n4kPlugin$WhenMappings;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/comahe/i18n4k/gradle/plugin/I18n4kPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "config", "Lde/comahe/i18n4k/gradle/plugin/I18n4kExtension;", "addDirectoryToSourceDirectorySet", "", "sourceDirectorySet", "Lorg/gradle/api/file/SourceDirectorySet;", "directory", "Ljava/io/File;", "addGeneratedLanguageFilesDirectoryToResources", "project", "addGeneratedSourcesDirectoryToSourceSets", "addNeededPlugins", "addTaskDependencies", "apply", "defineTasks", "findSourceDirectorySet", "type", "Lde/comahe/i18n4k/gradle/plugin/I18n4kPlugin$SourceDirectoryType;", "markGeneratedSourcesDirectoryAsGeneratedInIde", "ideaModel", "Lorg/gradle/plugins/ide/idea/model/IdeaModel;", "Companion", "SourceDirectoryType", "i18n4k-gradle-plugin"})
public class I18n4kPlugin
implements Plugin<Project> {
    private I18n4kExtension config;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getExtensions().create("i18n4k", I18n4kExtension.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026n4kExtension::class.java)");
        I18n4kExtension i18n4kExtension = this.config = (I18n4kExtension)object;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        if (i18n4kExtension.getGenerationTargetPlatform() == null) {
            GenerationTargetPlatform generationTargetPlatform;
            I18n4kExtension i18n4kExtension2 = this.config;
            if (i18n4kExtension2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            }
            if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
                generationTargetPlatform = GenerationTargetPlatform.MULTI_PLATFORM;
            } else if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.js")) {
                generationTargetPlatform = GenerationTargetPlatform.JS;
            } else if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.native")) {
                generationTargetPlatform = GenerationTargetPlatform.NATIVE;
            } else if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm")) {
                generationTargetPlatform = GenerationTargetPlatform.JVM;
            } else {
                throw (Throwable)new IllegalStateException("No of the supported Kotlin-Plugins (multiplatform, js, native, jvm) has be applied to the project");
            }
            i18n4kExtension2.setGenerationTargetPlatform(generationTargetPlatform);
        }
        this.addNeededPlugins(project);
        this.defineTasks(project);
        project.afterEvaluate((Action)new Action<Project>(this, project){
            final /* synthetic */ I18n4kPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Project it) {
                I18n4kPlugin.access$addTaskDependencies(this.this$0, this.$project);
            }
            {
                this.this$0 = i18n4kPlugin;
                this.$project = project;
            }
        });
        this.addGeneratedSourcesDirectoryToSourceSets(project);
        this.addGeneratedLanguageFilesDirectoryToResources(project);
        this.markGeneratedSourcesDirectoryAsGeneratedInIde(project, (IdeaModel)project.getExtensions().findByType(IdeaModel.class));
        project.getPlugins().withType(IdeaPlugin.class, (Action)new Action<IdeaPlugin>(this, project){
            final /* synthetic */ I18n4kPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(IdeaPlugin it) {
                IdeaPlugin ideaPlugin = it;
                Intrinsics.checkNotNullExpressionValue((Object)ideaPlugin, (String)"it");
                I18n4kPlugin.access$markGeneratedSourcesDirectoryAsGeneratedInIde(this.this$0, this.$project, ideaPlugin.getModel());
            }
            {
                this.this$0 = i18n4kPlugin;
                this.$project = project;
            }
        });
    }

    private final void addNeededPlugins(Project project) {
        project.getPluginManager().apply("org.gradle.idea");
    }

    private final void defineTasks(Project project) {
        project.getTasks().create("generateI18n4kFiles", GenerateI18n4kFilesTask.class, (Action)new Action<GenerateI18n4kFilesTask>(this){
            final /* synthetic */ I18n4kPlugin this$0;

            public final void execute(GenerateI18n4kFilesTask it) {
                it.setConfig(I18n4kPlugin.access$getConfig$p(this.this$0));
                GenerateI18n4kFilesTask generateI18n4kFilesTask = it;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)generateI18n4kFilesTask), (String)"it");
                generateI18n4kFilesTask.setDescription("Generate i18n4k files");
                it.setGroup("i18n");
            }
            {
                this.this$0 = i18n4kPlugin;
            }
        });
        project.getTasks().create("clearI18n4kFiles", ClearI18n4kFilesTask.class, (Action)new Action<ClearI18n4kFilesTask>(this){
            final /* synthetic */ I18n4kPlugin this$0;

            public final void execute(ClearI18n4kFilesTask it) {
                it.setConfig(I18n4kPlugin.access$getConfig$p(this.this$0));
                ClearI18n4kFilesTask clearI18n4kFilesTask = it;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)clearI18n4kFilesTask), (String)"it");
                clearI18n4kFilesTask.setDescription("Clear i18n4k files");
                it.setGroup("i18n");
            }
            {
                this.this$0 = i18n4kPlugin;
            }
        });
    }

    private final void addTaskDependencies(Project project) {
        block5: {
            Task task = (Task)project.getTasks().findByName("compileKotlin");
            if (task != null) {
                task.dependsOn(new Object[]{"generateI18n4kFiles"});
            }
            Task task2 = (Task)project.getTasks().findByName("compileJava");
            if (task2 != null) {
                task2.dependsOn(new Object[]{"generateI18n4kFiles"});
            }
            Task task3 = (Task)project.getTasks().findByName("compileKotlinJvm");
            if (task3 != null) {
                task3.dependsOn(new Object[]{"generateI18n4kFiles"});
            }
            Task task4 = (Task)project.getTasks().findByName("compileKotlinJs");
            if (task4 != null) {
                task4.dependsOn(new Object[]{"generateI18n4kFiles"});
            }
            Task task5 = (Task)project.getTasks().findByName("compileKotlinNative");
            if (task5 != null) {
                task5.dependsOn(new Object[]{"generateI18n4kFiles"});
            }
            Task task6 = (Task)project.getTasks().findByName("compileKotlinMetadata");
            if (task6 == null) break block5;
            task6.dependsOn(new Object[]{"generateI18n4kFiles"});
        }
    }

    private final SourceDirectorySet findSourceDirectorySet(Project project, SourceDirectoryType type) {
        SourceDirectorySet sourceDirectorySet;
        NamedDomainObjectContainer sourceSets = ((KotlinProjectExtension)project.getExtensions().getByType(KotlinProjectExtension.class)).getSourceSets();
        I18n4kExtension i18n4kExtension = this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        Object object = sourceSets.getByName(i18n4kExtension.getGenerationTargetPlatform() == GenerationTargetPlatform.MULTI_PLATFORM ? "commonMain" : "main");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet");
        }
        KotlinSourceSet sourceSet = (KotlinSourceSet)object;
        switch (I18n4kPlugin$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                sourceDirectorySet = sourceSet.getKotlin();
                break;
            }
            case 2: {
                sourceDirectorySet = sourceSet.getResources();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sourceDirectorySet;
    }

    private final void addDirectoryToSourceDirectorySet(SourceDirectorySet sourceDirectorySet, File directory) {
        Set dirs = sourceDirectorySet.getSrcDirs();
        Collection collection = dirs;
        boolean bl = false;
        collection.add(directory);
        sourceDirectorySet.srcDirs(new Object[]{dirs});
        Logger logger = ConstantsKt.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        if (logger.isDebugEnabled()) {
            Set set = sourceDirectorySet.getSrcDirs();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"sourceDirectorySet.srcDirs");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                ConstantsKt.getLogger().debug("{} - {}", (Object)sourceDirectorySet.getName(), (Object)it);
            }
        }
    }

    private final void addGeneratedSourcesDirectoryToSourceSets(Project project) {
        I18n4kExtension i18n4kExtension = this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        if (i18n4kExtension.getGenerationTargetPlatform() == GenerationTargetPlatform.JVM) {
            SourceDirectorySet sourceDirectorySet;
            Object v = project.getProperties().get("sourceSets");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.tasks.SourceSetContainer");
            }
            SourceSetContainer sourceSets = (SourceSetContainer)v;
            Object object = sourceSets.getByName("main");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSets.getByName(Sou\u2026Set.MAIN_SOURCE_SET_NAME)");
            SourceDirectorySet sourceDirectorySet2 = sourceDirectorySet = ((SourceSet)object).getJava();
            Intrinsics.checkNotNullExpressionValue((Object)sourceDirectorySet2, (String)"sourceDirectorySet");
            I18n4kExtension i18n4kExtension2 = this.config;
            if (i18n4kExtension2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            }
            this.addDirectoryToSourceDirectorySet(sourceDirectorySet2, Companion.getGeneratedSourcesDirectory(project, i18n4kExtension2));
        } else {
            SourceDirectorySet sourceDirectorySet = this.findSourceDirectorySet(project, SourceDirectoryType.KOTLIN);
            ConstantsKt.getLogger().info("Adding i18n4k generated sources directory to source set '" + sourceDirectorySet.getName() + '\'');
            I18n4kExtension i18n4kExtension3 = this.config;
            if (i18n4kExtension3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            }
            this.addDirectoryToSourceDirectorySet(sourceDirectorySet, Companion.getGeneratedSourcesDirectory(project, i18n4kExtension3));
        }
    }

    private final void addGeneratedLanguageFilesDirectoryToResources(Project project) {
        I18n4kExtension i18n4kExtension = this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        if (i18n4kExtension.getGenerationTargetPlatform() == GenerationTargetPlatform.JVM) {
            SourceDirectorySet sourceDirectorySet;
            Object v = project.getProperties().get("sourceSets");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.tasks.SourceSetContainer");
            }
            SourceSetContainer sourceSets = (SourceSetContainer)v;
            Object object = sourceSets.getByName("main");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSets.getByName(Sou\u2026Set.MAIN_SOURCE_SET_NAME)");
            SourceDirectorySet sourceDirectorySet2 = sourceDirectorySet = ((SourceSet)object).getResources();
            Intrinsics.checkNotNullExpressionValue((Object)sourceDirectorySet2, (String)"sourceDirectorySet");
            I18n4kExtension i18n4kExtension2 = this.config;
            if (i18n4kExtension2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            }
            this.addDirectoryToSourceDirectorySet(sourceDirectorySet2, Companion.getGeneratedLanguageFilesDirectory(project, i18n4kExtension2));
        } else {
            SourceDirectorySet sourceDirectorySet = this.findSourceDirectorySet(project, SourceDirectoryType.RESOURCES);
            ConstantsKt.getLogger().info("Adding i18n4k generated resources directory to source set '" + sourceDirectorySet.getName() + '\'');
            I18n4kExtension i18n4kExtension3 = this.config;
            if (i18n4kExtension3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            }
            this.addDirectoryToSourceDirectorySet(sourceDirectorySet, Companion.getGeneratedLanguageFilesDirectory(project, i18n4kExtension3));
        }
    }

    private final void markGeneratedSourcesDirectoryAsGeneratedInIde(Project project, IdeaModel ideaModel) {
        if (ideaModel == null) {
            ConstantsKt.getLogger().warn("Idea model not set? Missing idea plugin?");
            return;
        }
        ConstantsKt.getLogger().info("Mark i18n4k generated sources directory as 'generated' in IDEA");
        IdeaModule ideaModule = ideaModel.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)ideaModule, (String)"ideaModel.module");
        Set set = ideaModule.getGeneratedSourceDirs();
        I18n4kExtension i18n4kExtension = this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        set.add(Companion.getGeneratedSourcesDirectory(project, i18n4kExtension));
        Logger logger = ConstantsKt.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        if (logger.isDebugEnabled()) {
            IdeaModule ideaModule2 = ideaModel.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)ideaModule2, (String)"ideaModel.module");
            Set set2 = ideaModule2.getGeneratedSourceDirs();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"ideaModel.module.generatedSourceDirs");
            Iterable $this$forEach$iv = set2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                ConstantsKt.getLogger().debug("generatedSourceDirs[IDEA] - {}", (Object)it);
            }
        }
    }

    public static final /* synthetic */ void access$addTaskDependencies(I18n4kPlugin $this, Project project) {
        $this.addTaskDependencies(project);
    }

    public static final /* synthetic */ void access$markGeneratedSourcesDirectoryAsGeneratedInIde(I18n4kPlugin $this, Project project, IdeaModel ideaModel) {
        $this.markGeneratedSourcesDirectoryAsGeneratedInIde(project, ideaModel);
    }

    public static final /* synthetic */ I18n4kExtension access$getConfig$p(I18n4kPlugin $this) {
        I18n4kExtension i18n4kExtension = $this.config;
        if (i18n4kExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        return i18n4kExtension;
    }

    public static final /* synthetic */ void access$setConfig$p(I18n4kPlugin $this, I18n4kExtension i18n4kExtension) {
        $this.config = i18n4kExtension;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lde/comahe/i18n4k/gradle/plugin/I18n4kPlugin$SourceDirectoryType;", "", "(Ljava/lang/String;I)V", "KOTLIN", "RESOURCES", "i18n4k-gradle-plugin"})
    public static final class SourceDirectoryType
    extends Enum<SourceDirectoryType> {
        public static final /* enum */ SourceDirectoryType KOTLIN;
        public static final /* enum */ SourceDirectoryType RESOURCES;
        private static final /* synthetic */ SourceDirectoryType[] $VALUES;

        static {
            SourceDirectoryType[] sourceDirectoryTypeArray = new SourceDirectoryType[2];
            SourceDirectoryType[] sourceDirectoryTypeArray2 = sourceDirectoryTypeArray;
            sourceDirectoryTypeArray[0] = KOTLIN = new SourceDirectoryType();
            sourceDirectoryTypeArray[1] = RESOURCES = new SourceDirectoryType();
            $VALUES = sourceDirectoryTypeArray;
        }

        public static SourceDirectoryType[] values() {
            return (SourceDirectoryType[])$VALUES.clone();
        }

        public static SourceDirectoryType valueOf(String string) {
            return Enum.valueOf(SourceDirectoryType.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lde/comahe/i18n4k/gradle/plugin/I18n4kPlugin$Companion;", "", "()V", "getGeneratedLanguageFilesDirectory", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "config", "Lde/comahe/i18n4k/gradle/plugin/I18n4kExtension;", "getGeneratedSourcesDirectory", "i18n4k-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final File getGeneratedSourcesDirectory(@NotNull Project project, @NotNull I18n4kExtension config) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            String string = config.getSourceCodeOutputDirectory();
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
            String string2 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.buildDir.absolutePath");
            File dir = new File(StringsKt.replace$default((String)string, (String)"{buildDir}", (String)string2, (boolean)false, (int)4, null));
            dir.mkdirs();
            return dir;
        }

        @NotNull
        public final File getGeneratedLanguageFilesDirectory(@NotNull Project project, @NotNull I18n4kExtension config) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            String string = config.getLanguageFilesOutputDirectory();
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
            String string2 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.buildDir.absolutePath");
            File dir = new File(StringsKt.replace$default((String)string, (String)"{buildDir}", (String)string2, (boolean)false, (int)4, null));
            dir.mkdirs();
            return dir;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

