/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.generator;

import de.comahe.i18n4k.generator.GenerationTargetPlatform;
import de.comahe.i18n4k.generator.I18n4kGenerator;
import de.comahe.i18n4k.generator.MessagesDataBundle;
import de.comahe.i18n4k.generator.MessagesDataBundles;
import de.comahe.i18n4k.messages.formatter.MessageFormatter;
import java.io.File;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f\u0012\u0012\u0010\r\u001a\u000e\u0012\b\u0012\u00060\u000bj\u0002`\f\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017R\u0016\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\b\u0012\u00060\u000bj\u0002`\f\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/comahe/i18n4k/generator/I18n4kProcessor;", "", "inputDirectory", "Ljava/io/File;", "generatedSourcesDirectory", "generatedLanguageFilesDirectory", "generatedLanguageFilesDirAndroidRawResourceStyle", "", "packageName", "", "commentLocale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "sourceCodeLocales", "", "messageFormatter", "Lde/comahe/i18n4k/messages/formatter/MessageFormatter;", "generationTarget", "Lde/comahe/i18n4k/generator/GenerationTargetPlatform;", "logger", "Lorg/slf4j/Logger;", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;ZLjava/lang/String;Ljava/util/Locale;Ljava/util/List;Lde/comahe/i18n4k/messages/formatter/MessageFormatter;Lde/comahe/i18n4k/generator/GenerationTargetPlatform;Lorg/slf4j/Logger;)V", "execute", "", "i18n4k-generator"})
@SourceDebugExtension(value={"SMAP\nI18n4kProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 I18n4kProcessor.kt\nde/comahe/i18n4k/generator/I18n4kProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1855#2,2:73\n*S KotlinDebug\n*F\n+ 1 I18n4kProcessor.kt\nde/comahe/i18n4k/generator/I18n4kProcessor\n*L\n58#1:73,2\n*E\n"})
public final class I18n4kProcessor {
    @NotNull
    private final File inputDirectory;
    @NotNull
    private final File generatedSourcesDirectory;
    @NotNull
    private final File generatedLanguageFilesDirectory;
    private final boolean generatedLanguageFilesDirAndroidRawResourceStyle;
    @Nullable
    private final String packageName;
    @Nullable
    private final Locale commentLocale;
    @Nullable
    private final List<Locale> sourceCodeLocales;
    @NotNull
    private final MessageFormatter messageFormatter;
    @NotNull
    private final GenerationTargetPlatform generationTarget;
    @NotNull
    private final Logger logger;

    public I18n4kProcessor(@NotNull File inputDirectory, @NotNull File generatedSourcesDirectory, @NotNull File generatedLanguageFilesDirectory, boolean generatedLanguageFilesDirAndroidRawResourceStyle, @Nullable String packageName, @Nullable Locale commentLocale, @Nullable List<Locale> sourceCodeLocales, @NotNull MessageFormatter messageFormatter, @NotNull GenerationTargetPlatform generationTarget, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)inputDirectory, (String)"inputDirectory");
        Intrinsics.checkNotNullParameter((Object)generatedSourcesDirectory, (String)"generatedSourcesDirectory");
        Intrinsics.checkNotNullParameter((Object)generatedLanguageFilesDirectory, (String)"generatedLanguageFilesDirectory");
        Intrinsics.checkNotNullParameter((Object)messageFormatter, (String)"messageFormatter");
        Intrinsics.checkNotNullParameter((Object)((Object)generationTarget), (String)"generationTarget");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.inputDirectory = inputDirectory;
        this.generatedSourcesDirectory = generatedSourcesDirectory;
        this.generatedLanguageFilesDirectory = generatedLanguageFilesDirectory;
        this.generatedLanguageFilesDirAndroidRawResourceStyle = generatedLanguageFilesDirAndroidRawResourceStyle;
        this.packageName = packageName;
        this.commentLocale = commentLocale;
        this.sourceCodeLocales = sourceCodeLocales;
        this.messageFormatter = messageFormatter;
        this.generationTarget = generationTarget;
        this.logger = logger;
    }

    public final void execute() {
        MessagesDataBundles bundles = new MessagesDataBundles(this.messageFormatter);
        this.logger.info("I18n4k - starring generation...");
        this.logger.info("I18n4k - Base dir is: {}", (Object)new File(".").getAbsolutePath());
        this.logger.info("I18n4k - inputDirectory dir is: {}", (Object)this.inputDirectory.getAbsolutePath());
        this.logger.info("I18n4k - generatedSourcesDirectory dir is: {}", (Object)this.generatedSourcesDirectory.getAbsolutePath());
        this.logger.info("I18n4k - generatedLanguageFilesDirectory dir is: {}", (Object)this.generatedLanguageFilesDirectory.getAbsolutePath());
        this.logger.info("I18n4k - packageName is: {}", (Object)this.packageName);
        this.logger.info("I18n4k - commentLocale is: {}", (Object)this.commentLocale);
        this.logger.info("I18n4k - sourceCodeLocales is: {}", this.sourceCodeLocales);
        this.logger.info("I18n4k - generationTarget is: {}", (Object)this.generationTarget);
        this.logger.info("I18n4k - Clearing generatedSourcesDirectory...");
        FilesKt.deleteRecursively((File)this.generatedSourcesDirectory);
        this.logger.info("I18n4k - Clearing generatedLanguageFilesDirectory...");
        FilesKt.deleteRecursively((File)this.generatedLanguageFilesDirectory);
        this.logger.info("I18n4k - Searching for language bundles");
        bundles.findLanguageBundles(this.inputDirectory, this.packageName);
        this.logger.info("I18n4k - Found language bundles: " + bundles);
        Iterable $this$forEach$iv = bundles.getBundles().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessagesDataBundle data = (MessagesDataBundle)element$iv;
            boolean bl = false;
            this.logger.info("I18n4k - Generating code for language bundle: " + data.getName());
            new I18n4kGenerator(this.generatedSourcesDirectory, this.generatedLanguageFilesDirectory, this.generatedLanguageFilesDirAndroidRawResourceStyle, data, this.commentLocale, this.sourceCodeLocales, this.generationTarget).run();
        }
        this.logger.info("I18n4k - Finished!");
    }
}

