/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.generator;

import de.comahe.i18n4k.generator.BundleName;
import de.comahe.i18n4k.generator.MessagesData;
import de.comahe.i18n4k.generator.MessagesDataBundle;
import de.comahe.i18n4k.messages.formatter.MessageFormatter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u001e\u001a\u00020\u000eH\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/comahe/i18n4k/generator/MessagesDataBundles;", "", "messageFormatter", "Lde/comahe/i18n4k/messages/formatter/MessageFormatter;", "(Lde/comahe/i18n4k/messages/formatter/MessageFormatter;)V", "bundles", "", "Lde/comahe/i18n4k/generator/BundleName;", "Lde/comahe/i18n4k/generator/MessagesDataBundle;", "getBundles", "()Ljava/util/Map;", "addLanguageFile", "", "packageName", "", "file", "Ljava/io/File;", "addToBundles", "", "bundleName", "messagesData", "Lde/comahe/i18n4k/generator/MessagesData;", "findLanguageBundles", "inputDirectory", "findLanguageBundlesRecursive", "dir", "currentPackageName", "fixedPackageName", "loadProperties", "", "toString", "Companion", "i18n4k-generator"})
@SourceDebugExtension(value={"SMAP\nMessagesDataBundles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessagesDataBundles.kt\nde/comahe/i18n4k/generator/MessagesDataBundles\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n13579#2,2:135\n215#3,2:137\n1855#4,2:139\n*S KotlinDebug\n*F\n+ 1 MessagesDataBundles.kt\nde/comahe/i18n4k/generator/MessagesDataBundles\n*L\n51#1:135,2\n109#1:137,2\n118#1:139,2\n*E\n"})
public final class MessagesDataBundles {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageFormatter messageFormatter;
    @NotNull
    private final Map<BundleName, MessagesDataBundle> bundles;
    @NotNull
    private static final Pattern BUNDLE_FILE_PATTERN;

    public MessagesDataBundles(@NotNull MessageFormatter messageFormatter) {
        Intrinsics.checkNotNullParameter((Object)messageFormatter, (String)"messageFormatter");
        this.messageFormatter = messageFormatter;
        this.bundles = new LinkedHashMap();
    }

    @NotNull
    public final Map<BundleName, MessagesDataBundle> getBundles() {
        return this.bundles;
    }

    public final void findLanguageBundles(@NotNull File inputDirectory, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)inputDirectory, (String)"inputDirectory");
        this.findLanguageBundlesRecursive(inputDirectory, "", packageName);
    }

    private final void findLanguageBundlesRecursive(File dir, String currentPackageName, String fixedPackageName) {
        block3: {
            File[] fileArray = dir.listFiles();
            if (fileArray == null) break block3;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (file.isDirectory()) {
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    this.findLanguageBundlesRecursive(file, currentPackageName + (((CharSequence)currentPackageName).length() == 0 ? "" : ".") + file.getName(), fixedPackageName);
                    continue;
                }
                String string = fixedPackageName;
                if (string == null) {
                    string = currentPackageName;
                }
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                this.addLanguageFile(string, file);
            }
        }
    }

    public final boolean addLanguageFile(@NotNull String packageName, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Matcher matcher = BUNDLE_FILE_PATTERN.matcher(file.getName());
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"BUNDLE_FILE_PATTERN.matcher(file.name)");
        Matcher m = matcher;
        if (m.find()) {
            String string;
            String string2 = m.group(1);
            if (string2 == null) {
                return false;
            }
            BundleName bundleName = new BundleName(packageName, string2);
            String string3 = m.group(2);
            if (string3 == null) {
                return false;
            }
            String string4 = m.group(3);
            if (string4 == null) {
                string4 = "";
            }
            if ((string = m.group(4)) == null) {
                string = "";
            }
            this.addToBundles(bundleName, new MessagesData(new Locale(string3, string4, string), this.loadProperties(file)));
            return true;
        }
        return false;
    }

    private final void addToBundles(BundleName bundleName, MessagesData messagesData) {
        MessagesDataBundle messagesDataBundle = this.bundles.computeIfAbsent(bundleName, arg_0 -> MessagesDataBundles.addToBundles$lambda$1((Function1)new Function1<BundleName, MessagesDataBundle>(this){
            final /* synthetic */ MessagesDataBundles this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final MessagesDataBundle invoke(@NotNull BundleName n) {
                Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                return new MessagesDataBundle(n, MessagesDataBundles.access$getMessageFormatter$p(this.this$0));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)messagesDataBundle, (String)"private fun addToBundles\u2026sData(messagesData)\n    }");
        MessagesDataBundle bundle2 = messagesDataBundle;
        bundle2.addMessagesData(messagesData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> loadProperties(File file) {
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl = false;
            Properties p = new Properties();
            p.load(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            HashMap r = new HashMap(p.size());
            Map $this$forEach$iv = p;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl2 = false;
                ((Map)r).put(it.getKey().toString(), it.getValue().toString());
            }
            Map map = r;
            return map;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = this.bundles.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessagesDataBundle data = (MessagesDataBundle)element$iv;
            boolean bl = false;
            sb.append(data).append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final MessagesDataBundle addToBundles$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MessagesDataBundle)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ MessageFormatter access$getMessageFormatter$p(MessagesDataBundles $this) {
        return $this.messageFormatter;
    }

    static {
        Pattern pattern = Pattern.compile("^([^_]+)_([a-z]{2})(?:_([A-Z]{2}))?(?:_([a-zA-Z]+))?.properties$");
        Intrinsics.checkNotNull((Object)pattern);
        BUNDLE_FILE_PATTERN = pattern;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/comahe/i18n4k/generator/MessagesDataBundles$Companion;", "", "()V", "BUNDLE_FILE_PATTERN", "Ljava/util/regex/Pattern;", "getBUNDLE_FILE_PATTERN", "()Ljava/util/regex/Pattern;", "i18n4k-generator"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getBUNDLE_FILE_PATTERN() {
            return BUNDLE_FILE_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

