/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.generator;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import de.comahe.i18n4k.LocaleUtilsKt;
import de.comahe.i18n4k.generator.GenerationTargetPlatform;
import de.comahe.i18n4k.generator.I18n4kGenerator;
import de.comahe.i18n4k.generator.MessagesData;
import de.comahe.i18n4k.generator.MessagesDataBundle;
import de.comahe.i18n4k.messages.MessageBundle;
import de.comahe.i18n4k.messages.providers.MessagesProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\b\u0012\u00060\nj\u0002`\u000b\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\"\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\rH\u0002J\b\u0010$\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013H\u0002J\u0006\u0010'\u001a\u00020\u0019R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\b\u0012\u00060\nj\u0002`\u000b\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/comahe/i18n4k/generator/I18n4kGenerator;", "", "sourceDir", "Ljava/io/File;", "languageFilesDir", "languageFilesDirAndroidRawResourceStyle", "", "bundle", "Lde/comahe/i18n4k/generator/MessagesDataBundle;", "commentLocale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "sourceCodeLocales", "", "generationTarget", "Lde/comahe/i18n4k/generator/GenerationTargetPlatform;", "(Ljava/io/File;Ljava/io/File;ZLde/comahe/i18n4k/generator/MessagesDataBundle;Ljava/util/Locale;Ljava/util/List;Lde/comahe/i18n4k/generator/GenerationTargetPlatform;)V", "fieldNames", "Ljava/util/SortedMap;", "", "getFieldNames", "()Ljava/util/SortedMap;", "convertCamelToSnakeCase", "camelCase", "generateLanguageFiles", "", "generateLocalisationFile", "messagesData", "Lde/comahe/i18n4k/generator/MessagesData;", "generateLocalisationObject", "Lcom/squareup/kotlinpoet/TypeSpec;", "generateLocalisationText", "writer", "Ljava/io/Writer;", "generateMessagesObject", "sourceCodeLanguages", "generateSourceCode", "makeValidIdentifier", "str", "run", "i18n4k-generator"})
@SourceDebugExtension(value={"SMAP\nI18n4kGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 I18n4kGenerator.kt\nde/comahe/i18n4k/generator/I18n4kGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,348:1\n1855#2:349\n1855#2,2:350\n1856#2:352\n766#2:355\n857#2,2:356\n1855#2,2:358\n1603#2,9:360\n1855#2:369\n1856#2:371\n1612#2:372\n1855#2,2:373\n1789#2,3:377\n1855#2,2:384\n1855#2:388\n1856#2:391\n215#3,2:353\n215#3,2:375\n125#3:380\n152#3,3:381\n1#4:370\n37#5,2:386\n1295#6,2:389\n*S KotlinDebug\n*F\n+ 1 I18n4kGenerator.kt\nde/comahe/i18n4k/generator/I18n4kGenerator\n*L\n78#1:349\n79#1:350,2\n78#1:352\n122#1:355\n122#1:356,2\n125#1:358,2\n132#1:360,9\n132#1:369\n132#1:371\n132#1:372\n138#1:373,2\n199#1:377,3\n234#1:384,2\n322#1:388\n322#1:391\n85#1:353,2\n168#1:375,2\n209#1:380\n209#1:381,3\n132#1:370\n254#1:386,2\n324#1:389,2\n*E\n"})
public final class I18n4kGenerator {
    @NotNull
    private final File sourceDir;
    @NotNull
    private final File languageFilesDir;
    private final boolean languageFilesDirAndroidRawResourceStyle;
    @NotNull
    private final MessagesDataBundle bundle;
    @Nullable
    private final Locale commentLocale;
    @Nullable
    private List<Locale> sourceCodeLocales;
    @NotNull
    private final GenerationTargetPlatform generationTarget;
    @NotNull
    private final SortedMap<String, String> fieldNames;

    public I18n4kGenerator(@NotNull File sourceDir, @NotNull File languageFilesDir, boolean languageFilesDirAndroidRawResourceStyle, @NotNull MessagesDataBundle bundle2, @Nullable Locale commentLocale, @Nullable List<Locale> sourceCodeLocales, @NotNull GenerationTargetPlatform generationTarget) {
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        Intrinsics.checkNotNullParameter((Object)languageFilesDir, (String)"languageFilesDir");
        Intrinsics.checkNotNullParameter((Object)bundle2, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)((Object)generationTarget), (String)"generationTarget");
        this.sourceDir = sourceDir;
        this.languageFilesDir = languageFilesDir;
        this.languageFilesDirAndroidRawResourceStyle = languageFilesDirAndroidRawResourceStyle;
        this.bundle = bundle2;
        this.commentLocale = commentLocale;
        this.sourceCodeLocales = sourceCodeLocales;
        this.generationTarget = generationTarget;
        this.fieldNames = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        Iterable $this$forEach$iv = this.bundle.getMessageDataMap().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessagesData data = (MessagesData)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = data.getMessages().keySet();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String key = (String)element$iv2;
                boolean bl2 = false;
                this.fieldNames.computeIfAbsent(key, arg_0 -> I18n4kGenerator.lambda$2$lambda$1$lambda$0((Function1)new Function1<String, String>(this){
                    final /* synthetic */ I18n4kGenerator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final String invoke(String absentKey) {
                        Intrinsics.checkNotNullExpressionValue((Object)absentKey, (String)"absentKey");
                        return I18n4kGenerator.access$makeValidIdentifier(this.this$0, absentKey);
                    }
                }, arg_0));
            }
        }
        Map fieldNameKeys = new LinkedHashMap();
        Map $this$forEach$iv3 = this.fieldNames;
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            String fieldName = (String)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            String oldKey = fieldNameKeys.put(fieldName, key);
            if (oldKey == null) continue;
            throw new IllegalArgumentException("The fields '" + key + "' and '" + oldKey + "' map both to the same field name '" + fieldName + '\'');
        }
    }

    @NotNull
    public final SortedMap<String, String> getFieldNames() {
        return this.fieldNames;
    }

    private final String makeValidIdentifier(String str) {
        StringBuilder id = new StringBuilder(str);
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            if (Character.isDigit(id.charAt(0))) {
                id.insert(0, '_');
            } else {
                id.setCharAt(0, '_');
            }
        }
        int n = str.length();
        for (int i = 1; i < n; ++i) {
            char c = id.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            id.setCharAt(i, '_');
        }
        String string = id.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.toString()");
        return string;
    }

    public final void run() {
        this.generateSourceCode();
        this.generateLanguageFiles();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateLanguageFiles() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.bundle.getMessageDataMap().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MessagesData it = (MessagesData)element$iv$iv;
            boolean bl = false;
            List<Locale> list = this.sourceCodeLocales;
            if (!(!(list != null ? list.contains(it.getLocale()) : true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fileLanguages = (List)destination$iv$iv;
        Iterable $this$forEach$iv = fileLanguages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessagesData it = (MessagesData)element$iv;
            boolean bl = false;
            this.generateLocalisationFile(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSourceCode() {
        void $this$mapNotNullTo$iv$iv;
        List<Locale> list = this.sourceCodeLocales;
        Iterable $this$mapNotNull$iv = list != null ? (Collection)list : (Collection)this.bundle.getMessageDataMap().keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MessagesData it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Locale it = (Locale)element$iv$iv;
            boolean bl2 = false;
            if (this.bundle.getMessageDataMap().get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List sourceCodeLanguages = (List)destination$iv$iv;
        FileSpec.Builder file = FileSpec.Companion.builder(this.bundle.getName().getPackageName(), this.bundle.getName().getName());
        file.addType(this.generateMessagesObject(sourceCodeLanguages));
        Iterable $this$forEach$iv = sourceCodeLanguages;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            MessagesData it = (MessagesData)element$iv;
            boolean bl = false;
            file.addType(this.generateLocalisationObject(it));
        }
        file.build().writeTo(this.sourceDir);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateMessagesObject(List<MessagesData> sourceCodeLanguages) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry initCode;
        Map $this$fold$iv;
        TypeSpec.Builder builder;
        Object key;
        Object object;
        TypeSpec.Builder messageObject = TypeSpec.Companion.objectBuilder(this.bundle.getName().getName()).superclass(Reflection.getOrCreateKotlinClass(MessageBundle.class)).addSuperclassConstructorParameter('\"' + this.bundle.getName().getName() + "\", \"" + this.bundle.getName().getPackageName() + '\"', new Object[0]).addKdoc("Massage constants for bundle '" + this.bundle.getName().getName() + "'. Generated by i18n4k.", new Object[0]);
        int index = 0;
        Function1 paramCountToClass2 = generateMessagesObject.paramCountToClass.1.INSTANCE;
        Object $this$forEach$iv = this.fieldNames;
        boolean $i$f$forEach2 = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl = false;
            key = (String)object.getKey();
            String fieldName = (String)object.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            int paramCount = this.bundle.getMaxParameterIndexForKey((String)key) + 1;
            if (paramCount > 5) {
                throw new IllegalArgumentException("The field '" + (String)key + "' has more than 5 parameters!");
            }
            Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
            PropertySpec.Builder property = PropertySpec.Companion.builder(fieldName, (KClass)paramCountToClass2.invoke((Object)paramCount), new KModifier[0]).initializer(paramCount == 0 ? "getLocalizedString0(\"" + (String)key + "\", " + index + ')' : "getLocalizedStringFactory" + paramCount + "(\"" + (String)key + "\", " + index + ')', new Object[0]);
            if (this.generationTarget == GenerationTargetPlatform.JVM || this.generationTarget == GenerationTargetPlatform.ANDROID || this.generationTarget == GenerationTargetPlatform.MULTI_PLATFORM) {
                property.addAnnotation(Reflection.getOrCreateKotlinClass(JvmStatic.class));
            }
            if (this.commentLocale != null) {
                Object object2 = this.bundle.getMessageDataMap().get(this.commentLocale);
                if (object2 != null && (object2 = ((MessagesData)object2).getMessages()) != null && (object2 = (String)object2.get(key)) != null) {
                    Object text = object2;
                    boolean bl2 = false;
                    property.addKdoc((String)text, new Object[0]);
                }
            }
            messageObject.addProperty(property.build());
            ++index;
        }
        if (!((Collection)sourceCodeLanguages).isEmpty()) {
            void initial$iv;
            $this$forEach$iv = sourceCodeLanguages;
            CodeBlock.Builder $i$f$forEach2 = CodeBlock.Companion.builder();
            builder = messageObject;
            boolean $i$f$fold = false;
            CodeBlock.Builder accumulator$iv = initial$iv;
            object = $this$fold$iv.iterator();
            while (object.hasNext()) {
                void messagesData;
                Object element$iv = object.next();
                key = (MessagesData)element$iv;
                initCode = accumulator$iv;
                boolean bl = false;
                accumulator$iv = initCode.addStatement("registerTranslation(" + this.bundle.getName().getName() + '_' + messagesData.getLocale() + ')', new Object[0]);
            }
            builder.addInitializerBlock(accumulator$iv.build());
        }
        $this$fold$iv = this.fieldNames;
        StringBuilder stringBuilder = new StringBuilder().append("registerMessageBundleEntries(");
        CodeBlock.Builder builder2 = CodeBlock.Companion.builder();
        builder = messageObject;
        boolean $i$f$map = false;
        void $i$f$fold = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            initCode = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getValue());
        }
        collection = (List)destination$iv$iv;
        builder.addInitializerBlock(builder2.addStatement(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(')').toString(), new Object[0]).build());
        return messageObject.build();
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateLocalisationObject(MessagesData messagesData) {
        void $this$generateLocalisationObject_u24lambda_u2413;
        String[] stringArray = new String[]{"Locale"};
        ClassName localeClassName = new ClassName("de.comahe.i18n4k", stringArray);
        KModifier[] kModifierArray = new KModifier[]{KModifier.PRIVATE};
        TypeSpec.Builder localisationObject = TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Companion.objectBuilder(this.bundle.getName().getName() + '_' + messagesData.getLocale()).addModifiers(kModifierArray), (KClass)Reflection.getOrCreateKotlinClass(MessagesProvider.class), null, (int)2, null).addKdoc("Translation of message bundle '" + this.bundle.getName().getName() + "' for locale '" + messagesData.getLocale() + "'. Generated by i18n4k.", new Object[0]);
        List arrayParameter = new ArrayList();
        StringBuilder arrayText = new StringBuilder("arrayOf(\n");
        boolean first = false;
        first = true;
        Set<String> set = this.fieldNames.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"fieldNames.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            if (first) {
                first = false;
            } else {
                arrayText.append(",\n");
            }
            arrayText.append("%S");
            arrayParameter.add(messagesData.getMessages().get(key));
        }
        arrayText.append(")");
        Object[] objectArray = new KModifier[]{TypeName.copy$default((TypeName)((TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class))), (boolean)true, null, (int)2, null)};
        TypeName typeName = (TypeName)ParameterizedTypeName.Companion.get(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(String[].class)), (TypeName[])objectArray);
        objectArray = new KModifier[]{KModifier.PRIVATE};
        objectArray = PropertySpec.Companion.builder("_data", typeName, (KModifier[])objectArray);
        KModifier[] $i$f$forEach22 = objectArray;
        TypeSpec.Builder builder = localisationObject;
        boolean bl = false;
        String string = arrayText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arrayText.toString()");
        Collection $this$toTypedArray$iv = arrayParameter;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        $this$generateLocalisationObject_u24lambda_u2413.initializer(string, (Object[])Arrays.copyOf(stringArray2, stringArray2.length));
        if (this.generationTarget == GenerationTargetPlatform.JVM || this.generationTarget == GenerationTargetPlatform.ANDROID || this.generationTarget == GenerationTargetPlatform.MULTI_PLATFORM) {
            $this$generateLocalisationObject_u24lambda_u2413.addAnnotation(Reflection.getOrCreateKotlinClass(JvmStatic.class));
        }
        builder.addProperty(objectArray.build());
        objectArray = new KModifier[]{KModifier.OVERRIDE};
        PropertySpec.Builder builder2 = PropertySpec.Companion.builder("locale", (TypeName)localeClassName, (KModifier[])objectArray);
        objectArray = new Object[]{localeClassName};
        localisationObject.addProperty(builder2.initializer("%T(\"" + messagesData.getLocale() + "\")", objectArray).build());
        objectArray = new KModifier[]{KModifier.OVERRIDE};
        localisationObject.addProperty(PropertySpec.Companion.builder("size", Reflection.getOrCreateKotlinClass(Integer.TYPE), (KModifier[])objectArray).getter(FunSpec.Companion.getterBuilder().addCode("return _data.size", new Object[0]).build()).build());
        objectArray = new KModifier[]{KModifier.OVERRIDE};
        localisationObject.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("get").addModifiers((KModifier[])objectArray).addParameter(ParameterSpec.Companion.builder("index", Reflection.getOrCreateKotlinClass(Integer.TYPE), new KModifier[0]).build()), (TypeName)TypeName.copy$default((TypeName)((TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class))), (boolean)true, null, (int)2, null), null, (int)2, null).addCode("return _data[index]", new Object[0]).build());
        return localisationObject.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateLocalisationFile(MessagesData messagesData) {
        File file;
        this.languageFilesDir.mkdirs();
        if (this.languageFilesDirAndroidRawResourceStyle) {
            file = new File(this.languageFilesDir, this.convertCamelToSnakeCase(StringsKt.replace$default((String)this.bundle.getName().getPackageName(), (String)".", (String)"_", (boolean)false, (int)4, null) + '_' + this.bundle.getName().getName() + '_' + messagesData.getLocale() + "_i18n4k.txt"));
        } else {
            File dir = new File(this.languageFilesDir, StringsKt.replace$default((String)this.bundle.getName().getPackageName(), (String)".", (String)"/", (boolean)false, (int)4, null));
            dir.mkdirs();
            file = new File(dir, this.bundle.getName().getName() + '_' + messagesData.getLocale() + ".i18n4k.txt");
        }
        File file2 = file;
        Closeable closeable = new FileOutputStream(file2);
        Throwable throwable = null;
        try {
            FileOutputStream out = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            Throwable throwable2 = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)closeable2;
                boolean bl2 = false;
                this.generateLocalisationText(writer, messagesData);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void generateLocalisationText(Writer writer, MessagesData messagesData) {
        writer.append(LocaleUtilsKt.toTag((Locale)messagesData.getLocale())).append("\n^\n");
        Set<String> set = this.fieldNames.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"fieldNames.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            String text = messagesData.getMessages().get(key);
            String string = text;
            if (string != null && (string = StringsKt.lineSequence((CharSequence)string)) != null) {
                String $this$forEach$iv2 = string;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv2 = iterator.next();
                    String line = (String)element$iv2;
                    boolean bl2 = false;
                    if (StringsKt.startsWith$default((String)line, (String)"^", (boolean)false, (int)2, null)) {
                        writer.append("^");
                    }
                    writer.append(line).append("\n");
                }
            }
            writer.append("^\n");
        }
    }

    private final String convertCamelToSnakeCase(String camelCase) {
        StringBuilder snakeCase = new StringBuilder(camelCase.length() * 2);
        Character prevCharacter = null;
        int n = camelCase.length();
        for (int i = 0; i < n; ++i) {
            char character = camelCase.charAt(i);
            if (Character.isUpperCase(character)) {
                if (prevCharacter != null && Character.isLowerCase(prevCharacter.charValue())) {
                    snakeCase.append("_");
                }
                String string = String.valueOf(character);
                Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                snakeCase.append(string2);
            } else {
                snakeCase.append(character);
            }
            prevCharacter = Character.valueOf(character);
        }
        String string = snakeCase.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"snakeCase.toString()");
        return string;
    }

    private static final String lambda$2$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$makeValidIdentifier(I18n4kGenerator $this, String str) {
        return $this.makeValidIdentifier(str);
    }
}

