/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.generator;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import de.comahe.i18n4k.LocaleUtilsKt;
import de.comahe.i18n4k.generator.GenerationTargetPlatform;
import de.comahe.i18n4k.generator.I18n4kGenerator;
import de.comahe.i18n4k.generator.MessagesData;
import de.comahe.i18n4k.generator.MessagesDataBundle;
import de.comahe.i18n4k.messages.MessageBundle;
import de.comahe.i18n4k.messages.providers.MessagesProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u0012\u0012\u0010\n\u001a\u000e\u0012\b\u0012\u00060\bj\u0002`\t\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bH\u0002J\b\u0010 \u001a\u00020\u0015H\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0006\u0010#\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\b\u0012\u00060\bj\u0002`\t\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/comahe/i18n4k/generator/I18n4kGenerator;", "", "sourceDir", "Ljava/io/File;", "languageFilesDir", "bundle", "Lde/comahe/i18n4k/generator/MessagesDataBundle;", "commentLocale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "sourceCodeLocales", "", "generationTarget", "Lde/comahe/i18n4k/generator/GenerationTargetPlatform;", "(Ljava/io/File;Ljava/io/File;Lde/comahe/i18n4k/generator/MessagesDataBundle;Ljava/util/Locale;Ljava/util/List;Lde/comahe/i18n4k/generator/GenerationTargetPlatform;)V", "fieldNames", "Ljava/util/SortedMap;", "", "getFieldNames", "()Ljava/util/SortedMap;", "generateLanguageFiles", "", "generateLocalisationFile", "messagesData", "Lde/comahe/i18n4k/generator/MessagesData;", "generateLocalisationObject", "Lcom/squareup/kotlinpoet/TypeSpec;", "generateLocalisationText", "writer", "Ljava/io/Writer;", "generateMessagesObject", "sourceCodeLanguages", "generateSourceCode", "makeValidIdentifier", "str", "run", "i18n4k-generator"})
public final class I18n4kGenerator {
    @NotNull
    private final SortedMap<String, String> fieldNames;
    private final File sourceDir;
    private final File languageFilesDir;
    private final MessagesDataBundle bundle;
    private final Locale commentLocale;
    private List<Locale> sourceCodeLocales;
    private final GenerationTargetPlatform generationTarget;

    @NotNull
    public final SortedMap<String, String> getFieldNames() {
        return this.fieldNames;
    }

    /*
     * WARNING - void declaration
     */
    private final String makeValidIdentifier(String str) {
        char c;
        StringBuilder id = new StringBuilder(str);
        char c2 = id.charAt(0);
        int n = 0;
        if (!Character.isJavaIdentifierStart(c2)) {
            c2 = id.charAt(0);
            n = 0;
            if (Character.isDigit(c2)) {
                id.insert(0, '_');
            } else {
                StringBuilder stringBuilder = id;
                n = 0;
                char c3 = '_';
                c = '\u0000';
                stringBuilder.setCharAt(n, c3);
            }
        }
        int n2 = 1;
        n = str.length();
        while (n2 < n) {
            void i;
            char c4;
            c = c4 = id.charAt((int)i);
            char c5 = '\u0000';
            if (!Character.isJavaIdentifierPart(c)) {
                StringBuilder stringBuilder = id;
                c5 = '_';
                boolean bl = false;
                stringBuilder.setCharAt((int)i, c5);
            }
            ++i;
        }
        String string = id.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.toString()");
        return string;
    }

    public final void run() {
        this.generateSourceCode();
        this.generateLanguageFiles();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateLanguageFiles() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.bundle.getMessageDataMap().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MessagesData it = (MessagesData)element$iv$iv;
            boolean bl = false;
            List<Locale> list = this.sourceCodeLocales;
            if (!(!(list != null ? list.contains(it.getLocale()) : true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fileLanguages = (List)destination$iv$iv;
        Iterable $this$forEach$iv = fileLanguages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessagesData it = (MessagesData)element$iv;
            boolean bl = false;
            this.generateLocalisationFile(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSourceCode() {
        void $this$mapNotNullTo$iv$iv;
        List<Locale> list = this.sourceCodeLocales;
        Iterable $this$mapNotNull$iv = list != null ? (Collection)list : (Collection)this.bundle.getMessageDataMap().keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MessagesData messagesData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Locale it = (Locale)element$iv$iv;
            boolean bl2 = false;
            if (this.bundle.getMessageDataMap().get(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            MessagesData it$iv$iv = messagesData;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List sourceCodeLanguages = (List)destination$iv$iv;
        FileSpec.Builder file = FileSpec.Companion.builder(this.bundle.getName().getPackageName(), this.bundle.getName().getName());
        file.addType(this.generateMessagesObject(sourceCodeLanguages));
        Iterable $this$forEach$iv = sourceCodeLanguages;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            MessagesData it = (MessagesData)element$iv;
            boolean bl = false;
            file.addType(this.generateLocalisationObject(it));
        }
        file.build().writeTo(this.sourceDir);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateMessagesObject(List<MessagesData> sourceCodeLanguages) {
        Object $dstr$key$fieldName;
        TypeSpec.Builder messageObject = TypeSpec.Companion.objectBuilder(this.bundle.getName().getName()).superclass(Reflection.getOrCreateKotlinClass(MessageBundle.class)).addKdoc("Massage constants for bundle '" + this.bundle.getName().getName() + "'. Generated by i18n4k.", new Object[0]);
        int index = 0;
        Function1 paramCountToClass2 = generateMessagesObject.paramCountToClass.1.INSTANCE;
        Object $this$forEach$iv = this.fieldNames;
        boolean $i$f$forEach2 = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        for (Map.Entry element$iv : map.entrySet()) {
            Object object;
            String string;
            void key;
            $dstr$key$fieldName = element$iv;
            boolean bl2 = false;
            Map.Entry entry = $dstr$key$fieldName;
            boolean bl3 = false;
            String string2 = (String)entry.getKey();
            entry = $dstr$key$fieldName;
            bl3 = false;
            String fieldName = (String)entry.getValue();
            void v0 = key;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"key");
            int paramCount = this.bundle.getMaxParameterIndexForKey((String)v0) + 1;
            if (paramCount > 5) {
                throw (Throwable)new IllegalArgumentException("The field '" + (String)key + "' has more than 5 parameters!");
            }
            String string3 = fieldName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fieldName");
            PropertySpec.Builder builder = PropertySpec.Companion.builder(string3, (KClass)paramCountToClass2.invoke((Object)paramCount), new KModifier[0]);
            switch (paramCount) {
                case 0: {
                    string = "getLocalizedString0(" + index + ')';
                    break;
                }
                default: {
                    string = "getLocalizedStringFactory" + paramCount + '(' + index + ')';
                }
            }
            PropertySpec.Builder property = builder.initializer(string, new Object[0]);
            if (this.generationTarget == GenerationTargetPlatform.JVM || this.generationTarget == GenerationTargetPlatform.MULTI_PLATFORM) {
                property.addAnnotation(Reflection.getOrCreateKotlinClass(JvmStatic.class));
            }
            if (this.commentLocale != null && (object = this.bundle.getMessageDataMap().get(this.commentLocale)) != null && (object = ((MessagesData)object).getMessages()) != null && (object = (String)object.get(key)) != null) {
                Object object2 = object;
                boolean bl4 = false;
                boolean bl5 = false;
                Object text = object2;
                boolean bl6 = false;
                property.addKdoc((String)text, new Object[0]);
            }
            messageObject.addProperty(property.build());
            int n = index;
            index = n + 1;
        }
        $this$forEach$iv = sourceCodeLanguages;
        $i$f$forEach2 = false;
        if (!$this$forEach$iv.isEmpty()) {
            void $this$fold$iv;
            void initial$iv;
            $this$forEach$iv = sourceCodeLanguages;
            CodeBlock.Builder $i$f$forEach2 = CodeBlock.Companion.builder();
            TypeSpec.Builder builder = messageObject;
            boolean $i$f$fold = false;
            CodeBlock.Builder accumulator$iv = initial$iv;
            for (Map.Entry element$iv : $this$fold$iv) {
                void messagesData;
                $dstr$key$fieldName = (MessagesData)((Object)element$iv);
                void initCode = accumulator$iv;
                boolean bl7 = false;
                accumulator$iv = initCode.addStatement("registerTranslation(" + this.bundle.getName().getName() + '_' + messagesData.getLocale() + ')', new Object[0]);
            }
            void var23_30 = accumulator$iv;
            builder.addInitializerBlock(var23_30.build());
        }
        return messageObject.build();
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateLocalisationObject(MessagesData messagesData) {
        void $this$apply;
        Object element$iv2;
        ClassName localeClassName = new ClassName("de.comahe.i18n4k", new String[]{"Locale"});
        TypeSpec.Builder localisationObject = TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Companion.objectBuilder(this.bundle.getName().getName() + "_" + messagesData.getLocale()).addModifiers(new KModifier[]{KModifier.PRIVATE}), (KClass)Reflection.getOrCreateKotlinClass(MessagesProvider.class), null, (int)2, null).addKdoc("Translation of message bundle '" + this.bundle.getName().getName() + "' for locale '" + messagesData.getLocale() + "'. Generated by i18n4k.", new Object[0]);
        boolean bl = false;
        List arrayParameter = new ArrayList();
        StringBuilder arrayText = new StringBuilder("arrayOf(\n");
        boolean first = true;
        Set<String> set = this.fieldNames.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"fieldNames.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String key = (String)element$iv2;
            boolean bl2 = false;
            if (first) {
                first = false;
            } else {
                arrayText.append(",\n");
            }
            arrayText.append("%S");
            arrayParameter.add(messagesData.getMessages().get(key));
        }
        arrayText.append(")");
        PropertySpec.Builder builder = PropertySpec.Companion.builder("_data", (TypeName)ParameterizedTypeName.Companion.get(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(String[].class)), new TypeName[]{TypeName.copy$default((TypeName)((TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class))), (boolean)true, null, (int)2, null)}), new KModifier[]{KModifier.PRIVATE});
        boolean bl3 = false;
        boolean bl4 = false;
        element$iv2 = builder;
        TypeSpec.Builder builder2 = localisationObject;
        boolean bl5 = false;
        String string = arrayText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arrayText.toString()");
        Collection $this$toTypedArray$iv = arrayParameter;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$apply.initializer(string, (Object[])Arrays.copyOf(stringArray, stringArray.length));
        if (this.generationTarget == GenerationTargetPlatform.JVM || this.generationTarget == GenerationTargetPlatform.MULTI_PLATFORM) {
            $this$apply.addAnnotation(Reflection.getOrCreateKotlinClass(JvmStatic.class));
        }
        Unit unit = Unit.INSTANCE;
        builder2.addProperty(builder.build());
        localisationObject.addProperty(PropertySpec.Companion.builder("locale", (TypeName)localeClassName, new KModifier[]{KModifier.OVERRIDE}).initializer("%T(\"" + messagesData.getLocale() + "\")", new Object[]{localeClassName}).build());
        localisationObject.addProperty(PropertySpec.Companion.builder("size", Reflection.getOrCreateKotlinClass(Integer.TYPE), new KModifier[]{KModifier.OVERRIDE}).initializer("_data.size", new Object[0]).build());
        localisationObject.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("get").addModifiers(new KModifier[]{KModifier.OVERRIDE}).addParameter(ParameterSpec.Companion.builder("index", Reflection.getOrCreateKotlinClass(Integer.TYPE), new KModifier[0]).build()), (TypeName)TypeName.copy$default((TypeName)((TypeName)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class))), (boolean)true, null, (int)2, null), null, (int)2, null).addCode("return _data[index]", new Object[0]).build());
        return localisationObject.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateLocalisationFile(MessagesData messagesData) {
        File dir = new File(this.languageFilesDir, StringsKt.replace$default((String)this.bundle.getName().getPackageName(), (String)".", (String)"/", (boolean)false, (int)4, null));
        dir.mkdirs();
        File file = new File(dir, this.bundle.getName().getName() + "_" + messagesData.getLocale() + ".i18n4k.txt");
        Closeable closeable = new FileOutputStream(file);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileOutputStream out = (FileOutputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)closeable2;
                boolean bl6 = false;
                this.generateLocalisationText(writer, messagesData);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void generateLocalisationText(Writer writer, MessagesData messagesData) {
        writer.append(LocaleUtilsKt.toTag((Locale)messagesData.getLocale())).append("\n^\n");
        Set<String> set = this.fieldNames.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"fieldNames.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            String text = messagesData.getMessages().get(key);
            String string = text;
            if (string != null && (string = StringsKt.lineSequence((CharSequence)string)) != null) {
                String $this$forEach$iv2 = string;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv2 = iterator.next();
                    String line = (String)element$iv2;
                    boolean bl2 = false;
                    if (StringsKt.startsWith$default((String)line, (String)"^", (boolean)false, (int)2, null)) {
                        writer.append("^");
                    }
                    writer.append(line).append("\n");
                }
            }
            writer.append("^\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    public I18n4kGenerator(@NotNull File sourceDir, @NotNull File languageFilesDir, @NotNull MessagesDataBundle bundle2, @Nullable Locale commentLocale, @Nullable List<Locale> sourceCodeLocales, @NotNull GenerationTargetPlatform generationTarget) {
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        Intrinsics.checkNotNullParameter((Object)languageFilesDir, (String)"languageFilesDir");
        Intrinsics.checkNotNullParameter((Object)bundle2, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)((Object)generationTarget), (String)"generationTarget");
        this.sourceDir = sourceDir;
        this.languageFilesDir = languageFilesDir;
        this.bundle = bundle2;
        this.commentLocale = commentLocale;
        this.sourceCodeLocales = sourceCodeLocales;
        this.generationTarget = generationTarget;
        this.fieldNames = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        Iterable $this$forEach$iv = this.bundle.getMessageDataMap().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessagesData data = (MessagesData)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = data.getMessages().keySet();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String key = (String)element$iv2;
                boolean bl2 = false;
                this.fieldNames.computeIfAbsent(key, new Function<String, String>(this){
                    final /* synthetic */ I18n4kGenerator this$0;
                    {
                        this.this$0 = i18n4kGenerator;
                    }

                    public final String apply(String absentKey) {
                        String string = absentKey;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"absentKey");
                        return I18n4kGenerator.access$makeValidIdentifier(this.this$0, string);
                    }
                });
            }
        }
        $i$f$forEach = false;
        Map fieldNameKeys = new LinkedHashMap();
        Map $this$forEach$iv3 = this.fieldNames;
        boolean $i$f$forEach3 = false;
        Map map = $this$forEach$iv3;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            String fieldName;
            Map.Entry element$iv;
            Object element$iv2;
            Map.Entry $dstr$key$fieldName = element$iv = iterator.next();
            boolean bl3 = false;
            element$iv2 = $dstr$key$fieldName;
            boolean bl4 = false;
            String bl2 = (String)element$iv2.getKey();
            element$iv2 = $dstr$key$fieldName;
            bl4 = false;
            String string = fieldName = (String)element$iv2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fieldName");
            void v1 = key;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"key");
            String oldKey = (String)fieldNameKeys.put(string, v1);
            if (oldKey == null) continue;
            throw (Throwable)new IllegalArgumentException("The fields '" + (String)key + "' and '" + oldKey + "' map both to the same field name '" + fieldName + '\'');
        }
    }

    public static final /* synthetic */ String access$makeValidIdentifier(I18n4kGenerator $this, String str) {
        return $this.makeValidIdentifier(str);
    }
}

