/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.messages.formatter.types;

import de.comahe.i18n4k.messages.formatter.MessageValueFormatter;
import de.comahe.i18n4k.messages.formatter.parsing.MessageFormatContext;
import de.comahe.i18n4k.messages.formatter.parsing.StylePart;
import de.comahe.i18n4k.messages.formatter.parsing.StylePartToolsKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\b\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageTransformFormatters;", "", "()V", "all", "Lkotlinx/collections/immutable/PersistentList;", "Lde/comahe/i18n4k/messages/formatter/types/MessageTransformFormatters$TransformFormatter;", "getAll", "()Lkotlinx/collections/immutable/PersistentList;", "CapitalizeFormatter", "LowercaseFormatter", "TransformFormatter", "UppercaseFormatter", "i18n4k-core"})
public final class MessageTransformFormatters {
    @NotNull
    public static final MessageTransformFormatters INSTANCE = new MessageTransformFormatters();
    @NotNull
    private static final PersistentList<TransformFormatter> all;

    private MessageTransformFormatters() {
    }

    @NotNull
    public final PersistentList<TransformFormatter> getAll() {
        return all;
    }

    static {
        Object[] objectArray = new TransformFormatter[]{UppercaseFormatter.INSTANCE, LowercaseFormatter.INSTANCE, CapitalizeFormatter.INSTANCE};
        all = ExtensionsKt.persistentListOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageTransformFormatters$CapitalizeFormatter;", "Lde/comahe/i18n4k/messages/formatter/types/MessageTransformFormatters$TransformFormatter;", "()V", "formatString", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "value", "", "i18n4k-core"})
    public static final class CapitalizeFormatter
    extends TransformFormatter {
        @NotNull
        public static final CapitalizeFormatter INSTANCE = new CapitalizeFormatter();

        private CapitalizeFormatter() {
            super("capitalize");
        }

        @Override
        protected void formatString(@NotNull StringBuilder result, @NotNull CharSequence value) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value.length() == 0) {
                return;
            }
            result.append(Character.toUpperCase(value.charAt(0)));
            int n = value.length();
            for (int i = 1; i < n; ++i) {
                result.append(value.charAt(i));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageTransformFormatters$LowercaseFormatter;", "Lde/comahe/i18n4k/messages/formatter/types/MessageTransformFormatters$TransformFormatter;", "()V", "formatString", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "value", "", "i18n4k-core"})
    public static final class LowercaseFormatter
    extends TransformFormatter {
        @NotNull
        public static final LowercaseFormatter INSTANCE = new LowercaseFormatter();

        private LowercaseFormatter() {
            super("lowercase");
        }

        @Override
        protected void formatString(@NotNull StringBuilder result, @NotNull CharSequence value) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                result.append(Character.toLowerCase(c));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u0018H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageTransformFormatters$TransformFormatter;", "Lde/comahe/i18n4k/messages/formatter/MessageValueFormatter;", "typeId", "", "(Ljava/lang/String;)V", "getTypeId", "()Ljava/lang/String;", "format", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "value", "", "style", "Lde/comahe/i18n4k/messages/formatter/parsing/StylePart;", "parameters", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "context", "Lde/comahe/i18n4k/messages/formatter/parsing/MessageFormatContext;", "formatString", "", "i18n4k-core"})
    public static abstract class TransformFormatter
    implements MessageValueFormatter {
        @NotNull
        private final String typeId;

        public TransformFormatter(@NotNull String typeId) {
            Intrinsics.checkNotNullParameter((Object)typeId, (String)"typeId");
            this.typeId = typeId;
        }

        @Override
        @NotNull
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public void format(@NotNull StringBuilder result, @Nullable Object value, @Nullable StylePart style, @NotNull List<? extends Object> parameters, @NotNull Locale locale, @NotNull MessageFormatContext context) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = style;
            if (object == null || (object = StylePartToolsKt.toSimple((StylePart)object)) == null || (object = object.format(parameters, locale, context)) == null) {
                return;
            }
            Object textToTransform = object;
            result.ensureCapacity(result.length() + textToTransform.length());
            this.formatString(result, (CharSequence)textToTransform);
        }

        protected abstract void formatString(@NotNull StringBuilder var1, @NotNull CharSequence var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageTransformFormatters$UppercaseFormatter;", "Lde/comahe/i18n4k/messages/formatter/types/MessageTransformFormatters$TransformFormatter;", "()V", "formatString", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "value", "", "i18n4k-core"})
    public static final class UppercaseFormatter
    extends TransformFormatter {
        @NotNull
        public static final UppercaseFormatter INSTANCE = new UppercaseFormatter();

        private UppercaseFormatter() {
            super("uppercase");
        }

        @Override
        protected void formatString(@NotNull StringBuilder result, @NotNull CharSequence value) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                result.append(Character.toUpperCase(c));
            }
        }
    }
}

