/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.messages.formatter.types;

import de.comahe.i18n4k.messages.formatter.MessageValueFormatter;
import de.comahe.i18n4k.messages.formatter.parsing.MessageFormatContext;
import de.comahe.i18n4k.messages.formatter.parsing.StylePart;
import de.comahe.i18n4k.messages.formatter.parsing.StylePartToolsKt;
import de.comahe.i18n4k.strings.LocalizedNumberStringKt;
import de.comahe.i18n4k.strings.LocalizedString;
import de.comahe.i18n4k.strings.LocalizedStringNumber;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u000e\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters;", "", "()V", "all", "Lkotlinx/collections/immutable/PersistentList;", "Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$BaseNumberFormatter;", "getAll", "()Lkotlinx/collections/immutable/PersistentList;", "parsePrecisionFromFormatStyle", "", "formatStyle", "", "parseTailingFractionZerosFromFormatStyle", "", "AreaFormatter", "BaseNumberFormatter", "LengthFormatter", "NumberFormatter", "TimespanFormatter", "WeightFormatter", "i18n4k-core"})
public final class MessageNumberFormatters {
    @NotNull
    public static final MessageNumberFormatters INSTANCE = new MessageNumberFormatters();
    @NotNull
    private static final PersistentList<BaseNumberFormatter> all;

    private MessageNumberFormatters() {
    }

    @NotNull
    public final PersistentList<BaseNumberFormatter> getAll() {
        return all;
    }

    private final int parsePrecisionFromFormatStyle(CharSequence formatStyle) {
        int idxEnd;
        if (formatStyle == null || !StringsKt.startsWith$default((CharSequence)formatStyle, (CharSequence)"%", (boolean)false, (int)2, null)) {
            return Integer.MAX_VALUE;
        }
        int idxStart = StringsKt.indexOf$default((CharSequence)formatStyle, (String)".", (int)0, (boolean)false, (int)6, null);
        if (idxStart < 0 || idxStart + 1 >= formatStyle.length()) {
            return Integer.MAX_VALUE;
        }
        if (formatStyle.charAt(idxEnd = ++idxStart) == '-') {
            ++idxEnd;
        }
        while (formatStyle.length() > idxEnd && LocalizedNumberStringKt.isDigit(formatStyle.charAt(idxEnd))) {
            ++idxEnd;
        }
        Integer n = StringsKt.toIntOrNull((String)((Object)formatStyle.subSequence(idxStart, idxEnd)).toString());
        return n != null ? n : Integer.MAX_VALUE;
    }

    private final boolean parseTailingFractionZerosFromFormatStyle(CharSequence formatStyle) {
        if (formatStyle == null || !StringsKt.startsWith$default((CharSequence)formatStyle, (CharSequence)"%", (boolean)false, (int)2, null)) {
            return false;
        }
        return StringsKt.contains$default((CharSequence)formatStyle, (CharSequence)".0", (boolean)false, (int)2, null);
    }

    static {
        Object[] objectArray = new BaseNumberFormatter[]{NumberFormatter.INSTANCE, LengthFormatter.INSTANCE, AreaFormatter.INSTANCE, WeightFormatter.INSTANCE, TimespanFormatter.INSTANCE};
        all = ExtensionsKt.persistentListOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0014\u00a8\u0006\u000e"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$AreaFormatter;", "Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$BaseNumberFormatter;", "()V", "formatNumber", "", "value", "", "precision", "", "tailingFractionZeros", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "i18n4k-core"})
    public static final class AreaFormatter
    extends BaseNumberFormatter {
        @NotNull
        public static final AreaFormatter INSTANCE = new AreaFormatter();

        private AreaFormatter() {
            super("area");
        }

        @Override
        @NotNull
        protected CharSequence formatNumber(@NotNull Number value, int precision, boolean tailingFractionZeros, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            return LocalizedStringNumber.Companion.getFormattedArea(value.doubleValue(), value.doubleValue(), precision, tailingFractionZeros).toString(locale);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$BaseNumberFormatter;", "Lde/comahe/i18n4k/messages/formatter/MessageValueFormatter;", "typeId", "", "(Ljava/lang/String;)V", "getTypeId", "()Ljava/lang/String;", "format", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "value", "", "style", "Lde/comahe/i18n4k/messages/formatter/parsing/StylePart;", "parameters", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "context", "Lde/comahe/i18n4k/messages/formatter/parsing/MessageFormatContext;", "formatNumber", "", "", "precision", "", "tailingFractionZeros", "", "i18n4k-core"})
    public static abstract class BaseNumberFormatter
    implements MessageValueFormatter {
        @NotNull
        private final String typeId;

        public BaseNumberFormatter(@NotNull String typeId) {
            Intrinsics.checkNotNullParameter((Object)typeId, (String)"typeId");
            this.typeId = typeId;
        }

        @Override
        @NotNull
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public void format(@NotNull StringBuilder result, @Nullable Object value, @Nullable StylePart style, @NotNull List<? extends Object> parameters, @NotNull Locale locale, @NotNull MessageFormatContext context) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(value instanceof Number)) {
                if (value instanceof LocalizedString) {
                    result.append(((LocalizedString)value).toString(locale));
                } else {
                    result.append(String.valueOf(value));
                }
                return;
            }
            Object object = style;
            CharSequence formatStyle = object != null && (object = StylePartToolsKt.toSimple((StylePart)object)) != null ? object.format(parameters, locale, context) : null;
            result.append(this.formatNumber((Number)value, INSTANCE.parsePrecisionFromFormatStyle(formatStyle), INSTANCE.parseTailingFractionZerosFromFormatStyle(formatStyle), locale));
        }

        @NotNull
        protected abstract CharSequence formatNumber(@NotNull Number var1, int var2, boolean var3, @NotNull Locale var4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0014\u00a8\u0006\u000e"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$LengthFormatter;", "Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$BaseNumberFormatter;", "()V", "formatNumber", "", "value", "", "precision", "", "tailingFractionZeros", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "i18n4k-core"})
    public static final class LengthFormatter
    extends BaseNumberFormatter {
        @NotNull
        public static final LengthFormatter INSTANCE = new LengthFormatter();

        private LengthFormatter() {
            super("length");
        }

        @Override
        @NotNull
        protected CharSequence formatNumber(@NotNull Number value, int precision, boolean tailingFractionZeros, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            return LocalizedStringNumber.Companion.getFormattedLength(value.doubleValue(), value.doubleValue(), precision, tailingFractionZeros).toString(locale);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0014\u00a8\u0006\u000e"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$NumberFormatter;", "Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$BaseNumberFormatter;", "()V", "formatNumber", "", "value", "", "precision", "", "tailingFractionZeros", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "i18n4k-core"})
    public static final class NumberFormatter
    extends BaseNumberFormatter {
        @NotNull
        public static final NumberFormatter INSTANCE = new NumberFormatter();

        private NumberFormatter() {
            super("number");
        }

        @Override
        @NotNull
        protected CharSequence formatNumber(@NotNull Number value, int precision, boolean tailingFractionZeros, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            return LocalizedStringNumber.Companion.formatNumber(value, precision, tailingFractionZeros, locale);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0014\u00a8\u0006\u000e"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$TimespanFormatter;", "Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$BaseNumberFormatter;", "()V", "formatNumber", "", "value", "", "precision", "", "tailingFractionZeros", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "i18n4k-core"})
    public static final class TimespanFormatter
    extends BaseNumberFormatter {
        @NotNull
        public static final TimespanFormatter INSTANCE = new TimespanFormatter();

        private TimespanFormatter() {
            super("timespan");
        }

        @Override
        @NotNull
        protected CharSequence formatNumber(@NotNull Number value, int precision, boolean tailingFractionZeros, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            return LocalizedStringNumber.Companion.getFormattedTimeSpan(value.doubleValue()).toString(locale);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0014\u00a8\u0006\u000e"}, d2={"Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$WeightFormatter;", "Lde/comahe/i18n4k/messages/formatter/types/MessageNumberFormatters$BaseNumberFormatter;", "()V", "formatNumber", "", "value", "", "precision", "", "tailingFractionZeros", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "i18n4k-core"})
    public static final class WeightFormatter
    extends BaseNumberFormatter {
        @NotNull
        public static final WeightFormatter INSTANCE = new WeightFormatter();

        private WeightFormatter() {
            super("weight");
        }

        @Override
        @NotNull
        protected CharSequence formatNumber(@NotNull Number value, int precision, boolean tailingFractionZeros, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            return LocalizedStringNumber.Companion.getFormattedWeight(value.doubleValue(), value.doubleValue(), precision, tailingFractionZeros).toString(locale);
        }
    }
}

