/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.messages.formatter.parsing;

import de.comahe.i18n4k.messages.formatter.MessageValueFormatter;
import de.comahe.i18n4k.messages.formatter.parsing.MessageFormatContext;
import de.comahe.i18n4k.messages.formatter.parsing.MessagePart;
import de.comahe.i18n4k.messages.formatter.parsing.StylePart;
import de.comahe.i18n4k.strings.LocalizedString;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J2\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J6\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060!j\u0002`\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0$2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010(\u001a\u00020)H\u0016J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lde/comahe/i18n4k/messages/formatter/parsing/MessagePartParam;", "Lde/comahe/i18n4k/messages/formatter/parsing/MessagePart;", "index", "", "type", "", "style", "Lde/comahe/i18n4k/messages/formatter/parsing/StylePart;", "(Ljava/lang/Integer;Ljava/lang/CharSequence;Lde/comahe/i18n4k/messages/formatter/parsing/StylePart;)V", "getIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "maxParameterIndex", "getMaxParameterIndex", "()I", "getStyle", "()Lde/comahe/i18n4k/messages/formatter/parsing/StylePart;", "setStyle", "(Lde/comahe/i18n4k/messages/formatter/parsing/StylePart;)V", "getType", "()Ljava/lang/CharSequence;", "component1", "component2", "component3", "copy", "(Ljava/lang/Integer;Ljava/lang/CharSequence;Lde/comahe/i18n4k/messages/formatter/parsing/StylePart;)Lde/comahe/i18n4k/messages/formatter/parsing/MessagePartParam;", "equals", "", "other", "", "format", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "parameters", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "context", "Lde/comahe/i18n4k/messages/formatter/parsing/MessageFormatContext;", "hashCode", "toString", "", "i18n4k-core"})
public final class MessagePartParam
implements MessagePart {
    @Nullable
    private final Integer index;
    @Nullable
    private final CharSequence type;
    @Nullable
    private StylePart style;

    public MessagePartParam(@Nullable Integer index, @Nullable CharSequence type, @Nullable StylePart style) {
        this.index = index;
        this.type = type;
        this.style = style;
    }

    @Nullable
    public final Integer getIndex() {
        return this.index;
    }

    @Nullable
    public final CharSequence getType() {
        return this.type;
    }

    @Nullable
    public final StylePart getStyle() {
        return this.style;
    }

    public final void setStyle(@Nullable StylePart stylePart) {
        this.style = stylePart;
    }

    @Override
    public int getMaxParameterIndex() {
        Integer n = this.index;
        int n2 = n != null ? n : -1;
        StylePart stylePart = this.style;
        int n3 = stylePart != null ? stylePart.getMaxParameterIndex() : -1;
        return Math.max(n2, n3);
    }

    @Override
    public void format(@NotNull StringBuilder result, @NotNull List<? extends Object> parameters, @NotNull Locale locale, @NotNull MessageFormatContext context) {
        String value;
        Object object;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.index == null) {
            object = null;
        } else {
            if (this.index < 0 || this.index >= parameters.size()) {
                result.append("{").append(this.index).append("}");
                return;
            }
            object = value = parameters.get(this.index);
        }
        if (value instanceof LocalizedString) {
            value = ((LocalizedString)((Object)value)).toString(locale);
        }
        if (this.type == null) {
            if (value == null) {
                result.append("{~}");
            } else {
                result.append((Object)value);
            }
            return;
        }
        MessageValueFormatter formatter = (MessageValueFormatter)((Map)context.getFormatterTypes()).get(this.type);
        if (formatter == null) {
            if (value == null) {
                result.append("{~}");
            } else {
                result.append((Object)value);
            }
            return;
        }
        formatter.format(result, value, this.style, parameters, locale, context);
    }

    @Override
    @NotNull
    public CharSequence format(@NotNull List<? extends Object> parameters, @NotNull Locale locale, @NotNull MessageFormatContext context) {
        return MessagePart.DefaultImpls.format(this, parameters, locale, context);
    }

    @Nullable
    public final Integer component1() {
        return this.index;
    }

    @Nullable
    public final CharSequence component2() {
        return this.type;
    }

    @Nullable
    public final StylePart component3() {
        return this.style;
    }

    @NotNull
    public final MessagePartParam copy(@Nullable Integer index, @Nullable CharSequence type, @Nullable StylePart style) {
        return new MessagePartParam(index, type, style);
    }

    public static /* synthetic */ MessagePartParam copy$default(MessagePartParam messagePartParam, Integer n, CharSequence charSequence, StylePart stylePart, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = messagePartParam.index;
        }
        if ((n2 & 2) != 0) {
            charSequence = messagePartParam.type;
        }
        if ((n2 & 4) != 0) {
            stylePart = messagePartParam.style;
        }
        return messagePartParam.copy(n, charSequence, stylePart);
    }

    @NotNull
    public String toString() {
        return "MessagePartParam(index=" + this.index + ", type=" + this.type + ", style=" + this.style + ')';
    }

    public int hashCode() {
        int result = this.index == null ? 0 : ((Object)this.index).hashCode();
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.style == null ? 0 : this.style.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MessagePartParam)) {
            return false;
        }
        MessagePartParam messagePartParam = (MessagePartParam)other;
        if (!Intrinsics.areEqual((Object)this.index, (Object)messagePartParam.index)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)messagePartParam.type)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.style, (Object)messagePartParam.style);
    }
}

