/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.messages.formatter.parsing;

import de.comahe.i18n4k.I18n4kKt;
import de.comahe.i18n4k.messages.formatter.parsing.MessageParseException;
import de.comahe.i18n4k.messages.formatter.parsing.MessagePart;
import de.comahe.i18n4k.messages.formatter.parsing.MessagePartList;
import de.comahe.i18n4k.messages.formatter.parsing.MessagePartParam;
import de.comahe.i18n4k.messages.formatter.parsing.MessagePartText;
import de.comahe.i18n4k.messages.formatter.parsing.StylePart;
import de.comahe.i18n4k.messages.formatter.parsing.StylePartList;
import de.comahe.i18n4k.messages.formatter.parsing.StylePartNamed;
import de.comahe.i18n4k.messages.formatter.parsing.StylePartSimple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableList;
import kotlinx.collections.immutable.ImmutableSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J \u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u001f\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010!\u001a\u00020 2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\"\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/comahe/i18n4k/messages/formatter/parsing/MessageParser;", "", "message", "", "ignoreMessageParseErrors", "", "(Ljava/lang/CharSequence;Z)V", "findColon", "", "startIndex", "endIndex", "findCorrespondingCloseBrace", "findNext", "char", "", "findNextCloseBrace", "findNextComma", "findNextCorrespondingComma", "findNextOpenBrace", "findSlash", "findVerticalBar", "parseMessage", "Lde/comahe/i18n4k/messages/formatter/parsing/MessagePart;", "parseMessagePart", "parseMessagePartTrimmed", "parseNames", "Lkotlinx/collections/immutable/ImmutableSet;", "parseParameterIndex", "(II)Ljava/lang/Integer;", "parseParameterPattern", "Lde/comahe/i18n4k/messages/formatter/parsing/MessagePartParam;", "parseStyle", "Lde/comahe/i18n4k/messages/formatter/parsing/StylePart;", "parseStylePart", "readText", "i18n4k-core"})
public final class MessageParser {
    @NotNull
    private final CharSequence message;
    private final boolean ignoreMessageParseErrors;

    public MessageParser(@NotNull CharSequence message, boolean ignoreMessageParseErrors) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
        this.ignoreMessageParseErrors = ignoreMessageParseErrors;
    }

    public /* synthetic */ MessageParser(CharSequence charSequence, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = I18n4kKt.getI18n4k().getIgnoreMessageParseErrors();
        }
        this(charSequence, bl);
    }

    @NotNull
    public final MessagePart parseMessage() {
        return this.parseMessagePart(0, this.message.length());
    }

    private final MessagePart parseMessagePart(int startIndex, int endIndex) {
        int index = this.findNextOpenBrace(startIndex, endIndex);
        if (index >= endIndex) {
            return new MessagePartText(this.readText(startIndex, endIndex));
        }
        int lastIndex = startIndex;
        List parts = new ArrayList();
        while (true) {
            block6: {
                if (index > lastIndex) {
                    ((Collection)parts).add(new MessagePartText(this.readText(lastIndex, index)));
                }
                if ((lastIndex = index + 1) >= endIndex) break;
                index = this.findCorrespondingCloseBrace(lastIndex, endIndex);
                try {
                    ((Collection)parts).add(this.parseParameterPattern(lastIndex, index));
                }
                catch (MessageParseException e) {
                    if (this.ignoreMessageParseErrors) break block6;
                    throw e;
                }
            }
            lastIndex = index + 1;
            if (lastIndex >= endIndex) break;
            index = this.findNextOpenBrace(index, endIndex);
        }
        if (parts.size() == 1) {
            return (MessagePart)parts.get(0);
        }
        return new MessagePartList((ImmutableList<? extends MessagePart>)ExtensionsKt.toImmutableList((Iterable)parts));
    }

    private final MessagePart parseMessagePartTrimmed(int startIndex, int endIndex) {
        int startIndexNew;
        int endIndexNew = endIndex;
        for (startIndexNew = startIndex; this.message.length() > startIndexNew && CharsKt.isWhitespace((char)this.message.charAt(startIndexNew)); ++startIndexNew) {
        }
        while (startIndexNew < endIndexNew && CharsKt.isWhitespace((char)this.message.charAt(endIndexNew - 1))) {
            --endIndexNew;
        }
        return this.parseMessagePart(startIndexNew, endIndexNew);
    }

    private final MessagePartParam parseParameterPattern(int startIndex, int endIndex) {
        int lastIndex = startIndex;
        int index = this.findNextCorrespondingComma(lastIndex, endIndex);
        Integer parameterIndex = this.parseParameterIndex(lastIndex, index);
        if (index >= endIndex) {
            return new MessagePartParam(parameterIndex, null, null);
        }
        lastIndex = index + 1;
        index = this.findNextCorrespondingComma(lastIndex, endIndex);
        CharSequence parameterType = StringsKt.trim((CharSequence)this.readText(lastIndex, index));
        if (index >= endIndex) {
            return new MessagePartParam(parameterIndex, parameterType, null);
        }
        lastIndex = index + 1;
        if ((index = this.findNextCorrespondingComma(lastIndex, endIndex)) < endIndex) {
            throw new MessageParseException("Parameter pattern has more the two commas! Pattern: " + this.message.subSequence(startIndex, endIndex) + " - Message: " + this.message);
        }
        return new MessagePartParam(parameterIndex, parameterType, this.parseStyle(lastIndex, index));
    }

    private final Integer parseParameterIndex(int startIndex, int endIndex) {
        CharSequence text = StringsKt.trim((CharSequence)this.readText(startIndex, endIndex));
        if (Intrinsics.areEqual((Object)text, (Object)"~")) {
            return null;
        }
        Integer n = StringsKt.toIntOrNull((String)((Object)text).toString());
        if (n == null) {
            throw new MessageParseException("Parameter index (\"" + text + "\") is not a valid integer number! In Message: " + this.message);
        }
        int index = n;
        if (index < 0) {
            throw new MessageParseException("Parameter index (\"" + text + "\") must be positive or zero! In Message: " + this.message);
        }
        return index;
    }

    private final StylePart parseStyle(int startIndex, int endIndex) {
        int index = this.findVerticalBar(startIndex, endIndex);
        if (index >= endIndex) {
            return this.parseStylePart(startIndex, endIndex);
        }
        int lastIndex = startIndex;
        List parts = new ArrayList();
        ((Collection)parts).add(this.parseStylePart(lastIndex, index));
        do {
            lastIndex = index + 1;
            index = this.findVerticalBar(lastIndex, endIndex);
            ((Collection)parts).add(this.parseStylePart(lastIndex, index));
        } while (index < endIndex);
        return new StylePartList((ImmutableList<? extends StylePart>)ExtensionsKt.toImmutableList((Iterable)parts));
    }

    private final StylePart parseStylePart(int startIndex, int endIndex) {
        int index = this.findColon(startIndex, endIndex);
        if (index < endIndex) {
            return new StylePartNamed(this.parseNames(startIndex, index), this.parseMessagePartTrimmed(index + 1, endIndex));
        }
        return new StylePartSimple(this.parseMessagePartTrimmed(startIndex, endIndex));
    }

    private final ImmutableSet<CharSequence> parseNames(int startIndex, int endIndex) {
        int lastIndex = startIndex;
        Set names = new LinkedHashSet();
        while (true) {
            int index = this.findSlash(lastIndex, endIndex);
            ((Collection)names).add(StringsKt.trim((CharSequence)this.readText(lastIndex, index)));
            if (index >= endIndex) break;
            lastIndex = index + 1;
        }
        return ExtensionsKt.toImmutableSet((Iterable)names);
    }

    private final int findNextOpenBrace(int startIndex, int endIndex) {
        return this.findNext(startIndex, endIndex, '{');
    }

    private final int findNextCloseBrace(int startIndex, int endIndex) {
        return this.findNext(startIndex, endIndex, '}');
    }

    private final int findNextComma(int startIndex, int endIndex) {
        return this.findNext(startIndex, endIndex, ',');
    }

    private final int findVerticalBar(int startIndex, int endIndex) {
        return this.findNext(startIndex, endIndex, '|');
    }

    private final int findColon(int startIndex, int endIndex) {
        return this.findNext(startIndex, endIndex, ':');
    }

    private final int findSlash(int startIndex, int endIndex) {
        return this.findNext(startIndex, endIndex, '/');
    }

    private final int findCorrespondingCloseBrace(int startIndex, int endIndex) {
        int openIndex = startIndex - 1;
        int closeIndex = startIndex - 1;
        do {
            openIndex = this.findNextOpenBrace(openIndex + 1, endIndex);
            if ((closeIndex = this.findNextCloseBrace(closeIndex + 1, endIndex)) >= endIndex) {
                return endIndex;
            }
            if (openIndex < endIndex) continue;
            return closeIndex;
        } while (openIndex <= closeIndex);
        return closeIndex;
    }

    private final int findNextCorrespondingComma(int startIndex, int endIndex) {
        int index = startIndex;
        int commaIndex;
        while ((commaIndex = this.findNextComma(index, endIndex)) < endIndex) {
            int openIndex = this.findNextOpenBrace(index, endIndex);
            if (openIndex >= endIndex || commaIndex < openIndex) {
                return commaIndex;
            }
            int closeIndex = this.findCorrespondingCloseBrace(openIndex, endIndex);
            if (commaIndex > closeIndex) {
                return commaIndex;
            }
            index = closeIndex;
        }
        return endIndex;
    }

    private final int findNext(int startIndex, int endIndex, char c) {
        boolean inQuotes = false;
        boolean oneQuote = false;
        for (int index = startIndex; index < endIndex; ++index) {
            char c2 = this.message.charAt(index);
            Character cRead = null;
            if (oneQuote) {
                if (c2 != '\'') {
                    boolean bl = inQuotes = !inQuotes;
                }
                if (!inQuotes) {
                    cRead = Character.valueOf(c2);
                }
                oneQuote = false;
            } else if (inQuotes) {
                if (c2 == '\'') {
                    oneQuote = true;
                }
            } else if (c2 == '\'') {
                oneQuote = true;
            } else {
                cRead = Character.valueOf(c2);
            }
            if (cRead == null) continue;
            char c3 = c;
            if (cRead.charValue() != c3) continue;
            return index;
        }
        return endIndex;
    }

    private final CharSequence readText(int startIndex, int endIndex) {
        CharSequence subSequence = this.message.subSequence(startIndex, endIndex);
        if (StringsKt.indexOf$default((CharSequence)subSequence, (char)'\'', (int)0, (boolean)false, (int)6, null) < 0) {
            return subSequence;
        }
        StringBuilder buffer = new StringBuilder(endIndex - startIndex);
        boolean inQuotes = false;
        boolean oneQuote = false;
        for (int index = startIndex; index < endIndex; ++index) {
            char c = this.message.charAt(index);
            if (oneQuote) {
                if (c == '\'') {
                    buffer.append('\'');
                } else {
                    buffer.append(c);
                    inQuotes = !inQuotes;
                }
                oneQuote = false;
                continue;
            }
            if (inQuotes) {
                if (c == '\'') {
                    oneQuote = true;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '\'') {
                oneQuote = true;
                continue;
            }
            buffer.append(c);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

