/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.messages.formatter;

import de.comahe.i18n4k.messages.formatter.MessageFormatter;
import de.comahe.i18n4k.messages.formatter.MessageNumberFormatter;
import de.comahe.i18n4k.messages.formatter.MessageValueFormatter;
import de.comahe.i18n4k.strings.LocalizedString;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016J0\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/comahe/i18n4k/messages/formatter/MessageFormatterDefault;", "Lde/comahe/i18n4k/messages/formatter/MessageFormatter;", "()V", "valueFormatters", "", "", "Lde/comahe/i18n4k/messages/formatter/MessageValueFormatter;", "format", "", "message", "parameters", "", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "formatParameter", "p", "formatType", "formatStyle", "i18n4k-core"})
@SourceDebugExtension(value={"SMAP\nMessageFormatterDefault.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageFormatterDefault.kt\nde/comahe/i18n4k/messages/formatter/MessageFormatterDefault\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class MessageFormatterDefault
implements MessageFormatter {
    @NotNull
    public static final MessageFormatterDefault INSTANCE = new MessageFormatterDefault();
    @NotNull
    private static final Map<CharSequence, MessageValueFormatter> valueFormatters;

    private MessageFormatterDefault() {
    }

    @Override
    @NotNull
    public String format(@NotNull String message, @NotNull List<? extends Object> parameters, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        StringBuilder buffer = new StringBuilder(message.length() * 2);
        int argumentPartStartIndex = 0;
        CharSequence argumentIndex = null;
        CharSequence argumentFormatType = null;
        CharSequence argumentFormatStyle = null;
        boolean inQuote = false;
        boolean inBraces = false;
        int index = 0;
        int n = message.length();
        for (int i = 0; i < n; ++i) {
            char c = message.charAt(i);
            if (inQuote) {
                if (c == '\'') {
                    if (message.charAt(index - 1) == '\'') {
                        buffer.append('\'');
                    }
                    inQuote = false;
                } else {
                    buffer.append(c);
                }
            } else if (inBraces) {
                if (c == ',' || c == '}') {
                    CharSequence argumentPart = StringsKt.trim((CharSequence)message.subSequence(argumentPartStartIndex, index));
                    argumentPartStartIndex = index + 1;
                    if (argumentIndex == null) {
                        argumentIndex = argumentPart;
                    } else if (argumentFormatType == null) {
                        argumentFormatType = argumentPart;
                    } else if (argumentFormatStyle == null) {
                        argumentFormatStyle = argumentPart;
                    }
                }
                if (c == '}') {
                    Object argObject = null;
                    Integer argIndex = StringsKt.toIntOrNull((String)String.valueOf(argumentIndex));
                    if (argIndex != null && parameters.size() > argIndex) {
                        argObject = parameters.get(argIndex);
                    }
                    if (argObject == null) {
                        buffer.append('{').append(argumentIndex).append('}');
                    } else {
                        buffer.append(this.formatParameter(argObject, argumentFormatType, argumentFormatStyle, locale));
                    }
                    inBraces = false;
                    argumentIndex = null;
                    argumentFormatType = null;
                    argumentFormatStyle = null;
                }
            } else if (c == '\'') {
                inQuote = true;
            } else if (c == '{') {
                inBraces = true;
                argumentPartStartIndex = index + 1;
            } else {
                buffer.append(c);
            }
            ++index;
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    private final CharSequence formatParameter(Object p, CharSequence formatType, CharSequence formatStyle, Locale locale) {
        CharSequence charSequence;
        MessageValueFormatter messageValueFormatter;
        if (formatType != null && (messageValueFormatter = valueFormatters.get(formatType)) != null && (charSequence = messageValueFormatter.format(p, formatType, formatStyle, locale)) != null) {
            CharSequence it = charSequence;
            boolean bl = false;
            return it;
        }
        if (p instanceof LocalizedString) {
            return ((LocalizedString)p).toString(locale);
        }
        return p.toString();
    }

    @Override
    public int getMaxParameterIndex(@NotNull String message, @NotNull Locale locale) {
        return MessageFormatter.DefaultImpls.getMaxParameterIndex(this, message, locale);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"area", (Object)MessageNumberFormatter.INSTANCE), TuplesKt.to((Object)"length", (Object)MessageNumberFormatter.INSTANCE), TuplesKt.to((Object)"number", (Object)MessageNumberFormatter.INSTANCE), TuplesKt.to((Object)"timespan", (Object)MessageNumberFormatter.INSTANCE), TuplesKt.to((Object)"weight", (Object)MessageNumberFormatter.INSTANCE)};
        valueFormatters = MapsKt.mapOf((Pair[])pairArray);
    }
}

