/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.strings;

import de.comahe.i18n4k.I18n4kKt;
import de.comahe.i18n4k.strings.AbstractLocalizedString;
import de.comahe.i18n4k.strings.LocalizedNumberStringKt;
import de.comahe.i18n4k.strings.LocalizedString;
import de.comahe.i18n4k.strings.ParameterisedLocalizedString;
import de.comahe.i18n4k.strings.SimpleLocalizedString;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001dH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lde/comahe/i18n4k/strings/LocalizedStringNumber;", "Lde/comahe/i18n4k/strings/AbstractLocalizedString;", "number", "", "precision", "", "tailingFractionZeros", "", "(Ljava/lang/Number;IZ)V", "getNumber", "()Ljava/lang/Number;", "setNumber", "(Ljava/lang/Number;)V", "getPrecision", "()I", "getTailingFractionZeros", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "Companion", "NumberFormattingInfo", "i18n4k-core"})
public final class LocalizedStringNumber
extends AbstractLocalizedString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Number number;
    private final int precision;
    private final boolean tailingFractionZeros;
    @NotNull
    private static final NumberFormattingInfo defaultNumberFormattingInfo = new NumberFormattingInfo('.', ',', 3, 0);
    @NotNull
    private static final Map<String, NumberFormattingInfo> numberFormattingInfoPerLocaleId;

    @JvmOverloads
    public LocalizedStringNumber(@NotNull Number number, int precision, boolean tailingFractionZeros) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this.number = number;
        this.precision = precision;
        this.tailingFractionZeros = tailingFractionZeros;
    }

    public /* synthetic */ LocalizedStringNumber(Number number, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(number, n, bl);
    }

    @NotNull
    public final Number getNumber() {
        return this.number;
    }

    public final void setNumber(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"<set-?>");
        this.number = number;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final boolean getTailingFractionZeros() {
        return this.tailingFractionZeros;
    }

    @Override
    @NotNull
    public String toString() {
        return this.toString(null);
    }

    @Override
    @NotNull
    public String toString(@Nullable Locale locale) {
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = I18n4kKt.getI18n4k().getLocale();
        }
        return ((Object)Companion.formatNumber(this.number, this.precision, this.tailingFractionZeros, locale2)).toString();
    }

    @NotNull
    public final Number component1() {
        return this.number;
    }

    public final int component2() {
        return this.precision;
    }

    public final boolean component3() {
        return this.tailingFractionZeros;
    }

    @NotNull
    public final LocalizedStringNumber copy(@NotNull Number number, int precision, boolean tailingFractionZeros) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return new LocalizedStringNumber(number, precision, tailingFractionZeros);
    }

    public static /* synthetic */ LocalizedStringNumber copy$default(LocalizedStringNumber localizedStringNumber, Number number, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            number = localizedStringNumber.number;
        }
        if ((n2 & 2) != 0) {
            n = localizedStringNumber.precision;
        }
        if ((n2 & 4) != 0) {
            bl = localizedStringNumber.tailingFractionZeros;
        }
        return localizedStringNumber.copy(number, n, bl);
    }

    public int hashCode() {
        int result = this.number.hashCode();
        result = result * 31 + Integer.hashCode(this.precision);
        int n = this.tailingFractionZeros ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocalizedStringNumber)) {
            return false;
        }
        LocalizedStringNumber localizedStringNumber = (LocalizedStringNumber)other;
        if (!Intrinsics.areEqual((Object)this.number, (Object)localizedStringNumber.number)) {
            return false;
        }
        if (this.precision != localizedStringNumber.precision) {
            return false;
        }
        return this.tailingFractionZeros == localizedStringNumber.tailingFractionZeros;
    }

    @JvmOverloads
    public LocalizedStringNumber(@NotNull Number number, int precision) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this(number, precision, false, 4, null);
    }

    @JvmOverloads
    public LocalizedStringNumber(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this(number, 0, false, 6, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"de", (Object)new NumberFormattingInfo(',', '.', 3, 0))};
        numberFormattingInfoPerLocaleId = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\r\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eJ&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000eJ&\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u000eJ&\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010#\u001a\u00020\u00042\u000e\u0010\u0016\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018J\u0012\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0014\u0010&\u001a\u00020'2\n\u0010(\u001a\u00060\u000bj\u0002`\fH\u0002J\u0014\u0010)\u001a\u00020'2\n\u0010(\u001a\u00060\u000bj\u0002`\fH\u0002J\u001c\u0010*\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006+"}, d2={"Lde/comahe/i18n4k/strings/LocalizedStringNumber$Companion;", "", "()V", "defaultNumberFormattingInfo", "Lde/comahe/i18n4k/strings/LocalizedStringNumber$NumberFormattingInfo;", "numberFormattingInfoPerLocaleId", "", "", "getNumberFormattingInfoPerLocaleId", "()Ljava/util/Map;", "doubleToString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "number", "", "formatNumber", "", "", "precision", "", "tailingFractionZeros", "", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "getFormattedArea", "Lde/comahe/i18n4k/strings/LocalizedString;", "squareMeters", "unitValue", "getFormattedLength", "meters", "getFormattedTimeSpan", "durationInSeconds", "getFormattedWeight", "grams", "getNumberFormattingInfo", "getSpecialDoubleValuesString", "v", "normalizeNumber", "", "text", "removeTailingZeros", "roundToString", "i18n4k-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, NumberFormattingInfo> getNumberFormattingInfoPerLocaleId() {
            return numberFormattingInfoPerLocaleId;
        }

        @NotNull
        public final CharSequence formatNumber(@NotNull Number number, int precision, boolean tailingFractionZeros, @NotNull Locale locale) {
            CharSequence charSequence;
            boolean startsWithPlusOrMinus;
            StringBuilder b;
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            StringBuilder stringBuilder = b = precision == Integer.MAX_VALUE ? this.doubleToString(number.doubleValue()) : this.roundToString(number.doubleValue(), precision);
            if (!tailingFractionZeros) {
                this.removeTailingZeros(b);
            }
            NumberFormattingInfo f = this.getNumberFormattingInfo(locale);
            int fractionSignIndex = b.indexOf(".");
            if (fractionSignIndex < 0 && (f.getGroupIntegerSize() <= 0 || b.length() < f.getGroupIntegerSize())) {
                String string = b.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"b.toString()");
                return string;
            }
            boolean bl = startsWithPlusOrMinus = b.charAt(0) == '+' || b.charAt(0) == '-';
            if (fractionSignIndex >= 0) {
                charSequence = b;
                char c = f.getFractionSign();
                charSequence.setCharAt(fractionSignIndex, c);
                if (f.getGroupFractionSize() > 0) {
                    for (int idx = fractionSignIndex + 1 + f.getGroupFractionSize(); idx < b.length(); idx += 1 + f.getGroupFractionSize()) {
                        b.insert(idx, f.getGroupingSign());
                    }
                }
            } else {
                fractionSignIndex = b.length();
            }
            if (f.getGroupIntegerSize() > 0) {
                int idx = fractionSignIndex - f.getGroupIntegerSize();
                while (true) {
                    boolean bl2 = startsWithPlusOrMinus ? idx > 1 : idx > 0;
                    if (!bl2) break;
                    b.insert(idx, f.getGroupingSign());
                    idx -= f.getGroupIntegerSize();
                }
            }
            charSequence = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"b.toString()");
            return charSequence;
        }

        @NotNull
        public final NumberFormattingInfo getNumberFormattingInfo(@Nullable Locale locale) {
            NumberFormattingInfo f = locale == null ? null : this.getNumberFormattingInfoPerLocaleId().get(locale.getLanguage());
            NumberFormattingInfo numberFormattingInfo = f;
            if (numberFormattingInfo == null) {
                numberFormattingInfo = defaultNumberFormattingInfo;
            }
            return numberFormattingInfo;
        }

        private final StringBuilder roundToString(double number, int precision) {
            boolean negativ = number < 0.0;
            double modifiedNumber = Math.abs(number);
            double d = 10.0;
            double d2 = -((double)precision);
            double f = Math.pow(d, d2);
            if (precision != 0) {
                modifiedNumber /= f;
            }
            StringBuilder text = null;
            if (precision < 0) {
                double roundedValue = Math.rint(modifiedNumber) * f;
                if (roundedValue == 0.0) {
                    return new StringBuilder("0");
                }
                text = new StringBuilder(String.valueOf(roundedValue));
                this.removeTailingZeros(text);
            } else if (modifiedNumber > 9.223372036854776E18) {
                text = new StringBuilder(String.valueOf(number));
            } else {
                long longValue = MathKt.roundToLong((double)modifiedNumber);
                if (longValue == 0L) {
                    text = new StringBuilder("0");
                    if (precision > 0) {
                        text.append(".");
                        int n = 1;
                        if (n <= precision) {
                            int i;
                            do {
                                i = n++;
                                text.append("0");
                            } while (i != precision);
                        }
                    }
                    return text;
                }
                text = new StringBuilder(String.valueOf(longValue));
                if (precision > 0) {
                    int signIndex = text.length() - precision;
                    while (signIndex < 0) {
                        text.insert(0, "0");
                        int n = signIndex;
                        signIndex = n + 1;
                    }
                    text.insert(signIndex, signIndex == 0 ? "0." : ".");
                }
            }
            if (negativ) {
                text.insert(0, "-");
            }
            this.normalizeNumber(text);
            return text;
        }

        private final StringBuilder doubleToString(double number) {
            StringBuilder text = new StringBuilder(String.valueOf(number));
            this.normalizeNumber(text);
            int fractionSignIndex = text.indexOf(".");
            if (StringsKt.contains((CharSequence)text, (char)'e', (boolean)true)) {
                int n = text.indexOf("e");
                int n2 = text.indexOf("E");
                int exponentSignIndex = Math.max(n, n2);
                String string = text.substring(exponentSignIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.substring(exponentSignIndex + 1)");
                int exponent = Integer.parseInt(string);
                if (exponent < 0 && fractionSignIndex >= 0 && fractionSignIndex < exponentSignIndex) {
                    exponent -= exponentSignIndex - fractionSignIndex - 1;
                }
                if (Math.abs(exponent) >= 16) {
                    return text;
                }
                text = exponent < 0 ? this.roundToString(number, -exponent) : this.roundToString(number, 14 - exponent);
            } else {
                int n;
                if (fractionSignIndex < 0) {
                    return text;
                }
                int numberLength = text.length();
                if (number < 0.0) {
                    n = numberLength;
                    numberLength = n + -1;
                }
                if (Math.abs(number) < 1.0) {
                    n = numberLength;
                    numberLength = n + -1;
                }
                if (numberLength > 16) {
                    n = 0;
                    int n3 = text.length() - fractionSignIndex - 3;
                    text = this.roundToString(number, Math.max(n, n3));
                }
            }
            this.removeTailingZeros(text);
            return text;
        }

        private final void removeTailingZeros(StringBuilder text) {
            int fractionSignIndex = text.indexOf(".");
            if (fractionSignIndex < 0) {
                return;
            }
            int n = text.length() - 1;
            if (fractionSignIndex <= n) {
                int i;
                do {
                    char digit;
                    if ((digit = text.charAt(i = n--)) == '.') {
                        text.setLength(i);
                        break;
                    }
                    if (digit == '0') continue;
                    text.setLength(i + 1);
                    break;
                } while (i != fractionSignIndex);
            }
        }

        private final void normalizeNumber(StringBuilder text) {
            int plusSign;
            int n = 0;
            int n2 = text.length();
            while (n < n2) {
                int i;
                if (LocalizedNumberStringKt.isDigit(text.charAt(i = n++))) continue;
                StringBuilder stringBuilder = text;
                char c = Character.toLowerCase(text.charAt(i));
                stringBuilder.setCharAt(i, c);
            }
            while ((plusSign = text.indexOf("+")) >= 0) {
                StringBuilder stringBuilder = text.deleteCharAt(plusSign);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"this.deleteCharAt(index)");
            }
        }

        @NotNull
        public final LocalizedString getFormattedLength(double meters) {
            return this.getFormattedLength(meters, meters, Integer.MAX_VALUE, true);
        }

        @NotNull
        public final LocalizedString getFormattedLength(double meters, double unitValue, int precision, boolean tailingFractionZeros) {
            double meters2 = meters;
            double unitValue2 = unitValue;
            String string = this.getSpecialDoubleValuesString(meters2);
            if (string != null) {
                String it = string;
                boolean bl = false;
                return new SimpleLocalizedString(it);
            }
            unitValue2 = Math.abs(unitValue2);
            String unit = "m";
            if (unitValue2 < 1.0) {
                meters2 *= 1000.0;
                unit = "mm";
            } else if (unitValue2 >= 1000.0) {
                meters2 *= 0.001;
                unit = "km";
            }
            Object[] objectArray = new Object[]{new LocalizedStringNumber(meters2, precision, tailingFractionZeros), unit};
            return new ParameterisedLocalizedString("{0} {1}", CollectionsKt.listOf((Object[])objectArray));
        }

        @NotNull
        public final LocalizedString getFormattedWeight(double grams) {
            return this.getFormattedWeight(grams, grams, Integer.MAX_VALUE, true);
        }

        @NotNull
        public final LocalizedString getFormattedWeight(double grams, double unitValue, int precision, boolean tailingFractionZeros) {
            double grams2 = grams;
            double unitValue2 = unitValue;
            String string = this.getSpecialDoubleValuesString(grams2);
            if (string != null) {
                String it = string;
                boolean bl = false;
                return new SimpleLocalizedString(it);
            }
            unitValue2 = Math.abs(unitValue2);
            String unit = "g";
            if (unitValue2 < 1.0) {
                grams2 *= 1000.0;
                unit = "mg";
            } else if (unitValue2 >= 1000000.0) {
                grams2 *= 1.0E-6;
                unit = "t";
            } else if (unitValue2 >= 1000.0) {
                grams2 *= 0.001;
                unit = "kg";
            }
            Object[] objectArray = new Object[]{new LocalizedStringNumber(grams2, precision, tailingFractionZeros), unit};
            return new ParameterisedLocalizedString("{0} {1}", CollectionsKt.listOf((Object[])objectArray));
        }

        @NotNull
        public final LocalizedString getFormattedArea(double squareMeters) {
            return this.getFormattedArea(squareMeters, squareMeters, Integer.MAX_VALUE, true);
        }

        @NotNull
        public final LocalizedString getFormattedArea(double squareMeters, double unitValue, int precision, boolean tailingFractionZeros) {
            double squareMeters2 = squareMeters;
            double unitValue2 = unitValue;
            String string = this.getSpecialDoubleValuesString(squareMeters2);
            if (string != null) {
                String it = string;
                boolean bl = false;
                return new SimpleLocalizedString(it);
            }
            unitValue2 = Math.abs(unitValue2);
            String unit = "m\u00b2";
            if (unitValue2 < 0.001) {
                squareMeters2 *= 1000000.0;
                unit = "mm\u00b2";
            }
            if (unitValue2 >= 100000.0) {
                squareMeters2 /= 1000000.0;
                unit = "km\u00b2";
            }
            Object[] objectArray = new Object[]{new LocalizedStringNumber(squareMeters2, precision, tailingFractionZeros), unit};
            return new ParameterisedLocalizedString("{0} {1}", CollectionsKt.listOf((Object[])objectArray));
        }

        @NotNull
        public final LocalizedString getFormattedTimeSpan(double durationInSeconds) {
            double durationInSeconds2 = durationInSeconds;
            String string = this.getSpecialDoubleValuesString(durationInSeconds2);
            if (string != null) {
                String it = string;
                boolean bl = false;
                return new SimpleLocalizedString(it);
            }
            String sign = "";
            if (durationInSeconds2 < 0.0) {
                sign = "-";
                durationInSeconds2 = -durationInSeconds2;
            }
            if (durationInSeconds2 > 2.147483647E9) {
                return new SimpleLocalizedString(Character.valueOf('!'));
            }
            if (durationInSeconds2 < 1.0) {
                return new SimpleLocalizedString(sign + durationInSeconds2 + " s");
            }
            if (durationInSeconds2 < 60.0) {
                LocalizedStringNumber seconds = new LocalizedStringNumber(durationInSeconds2, 1, false, 4, null);
                return new ParameterisedLocalizedString(Intrinsics.stringPlus((String)sign, (Object)"{0} s"), CollectionsKt.listOf((Object)seconds));
            }
            int secondsTotal = (int)Math.rint(durationInSeconds2);
            int seconds = secondsTotal % 60;
            int minutes = secondsTotal / 60 % 60;
            int hours = secondsTotal / 60 / 60 % 24;
            int days = secondsTotal / 60 / 60 / 24;
            StringBuilder sb = new StringBuilder();
            sb.append(sign);
            if (days > 0) {
                sb.append(days).append("d ");
            }
            if (hours > 0) {
                sb.append(hours);
                if (minutes > 0 || seconds > 0) {
                    sb.append(":");
                    if (minutes < 10) {
                        sb.append("0");
                    }
                    sb.append(minutes);
                }
                if (seconds > 0) {
                    sb.append(":");
                    if (seconds < 10) {
                        sb.append("0");
                    }
                    sb.append(seconds);
                }
                sb.append(" h");
            } else if (minutes > 0) {
                sb.append(minutes);
                if (seconds > 0) {
                    sb.append(":");
                    if (seconds < 10) {
                        sb.append("0");
                    }
                    sb.append(seconds);
                }
                sb.append(" min");
            } else if (seconds > 0) {
                sb.append(seconds).append(" s");
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
            return new SimpleLocalizedString(string2);
        }

        private final String getSpecialDoubleValuesString(double v) {
            if (Double.isInfinite(v)) {
                return v > 0.0 ? "\u221e" : "-\u221e";
            }
            return Double.isNaN(v) ? "NaN" : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lde/comahe/i18n4k/strings/LocalizedStringNumber$NumberFormattingInfo;", "", "fractionSign", "", "groupingSign", "groupIntegerSize", "", "groupFractionSize", "(CCII)V", "getFractionSign", "()C", "getGroupFractionSize", "()I", "getGroupIntegerSize", "getGroupingSign", "i18n4k-core"})
    public static final class NumberFormattingInfo {
        private final char fractionSign;
        private final char groupingSign;
        private final int groupIntegerSize;
        private final int groupFractionSize;

        public NumberFormattingInfo(char fractionSign, char groupingSign, int groupIntegerSize, int groupFractionSize) {
            this.fractionSign = fractionSign;
            this.groupingSign = groupingSign;
            this.groupIntegerSize = groupIntegerSize;
            this.groupFractionSize = groupFractionSize;
        }

        public final char getFractionSign() {
            return this.fractionSign;
        }

        public final char getGroupingSign() {
            return this.groupingSign;
        }

        public final int getGroupIntegerSize() {
            return this.groupIntegerSize;
        }

        public final int getGroupFractionSize() {
            return this.groupFractionSize;
        }
    }
}

