/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.i18n4k.messages.formatter;

import de.comahe.i18n4k.messages.formatter.MessageValueFormatter;
import de.comahe.i18n4k.strings.LocalizedNumberStringKt;
import de.comahe.i18n4k.strings.LocalizedString;
import de.comahe.i18n4k.strings.LocalizedStringNumber;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/comahe/i18n4k/messages/formatter/MessageNumberFormatter;", "Lde/comahe/i18n4k/messages/formatter/MessageValueFormatter;", "()V", "FORMAT_STYLE_AREA", "", "FORMAT_STYLE_LENGTH", "FORMAT_STYLE_NUMBER", "FORMAT_STYLE_TIMESPAN", "FORMAT_STYLE_WEIGHT", "format", "", "value", "", "formatType", "formatStyle", "locale", "Ljava/util/Locale;", "Lde/comahe/i18n4k/Locale;", "parsePrecisionFromFormatStyle", "", "parseTailingFractionZerosFromFormatStyle", "", "i18n4k-core"})
public final class MessageNumberFormatter
implements MessageValueFormatter {
    @NotNull
    public static final MessageNumberFormatter INSTANCE = new MessageNumberFormatter();
    @NotNull
    public static final String FORMAT_STYLE_NUMBER = "number";
    @NotNull
    public static final String FORMAT_STYLE_LENGTH = "length";
    @NotNull
    public static final String FORMAT_STYLE_AREA = "area";
    @NotNull
    public static final String FORMAT_STYLE_WEIGHT = "weight";
    @NotNull
    public static final String FORMAT_STYLE_TIMESPAN = "timespan";

    private MessageNumberFormatter() {
    }

    @Override
    @NotNull
    public CharSequence format(@NotNull Object value, @NotNull CharSequence formatType, @Nullable CharSequence formatStyle, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)formatType, (String)"formatType");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (!(value instanceof Number)) {
            if (value instanceof LocalizedString) {
                return ((LocalizedString)value).toString(locale);
            }
            return value.toString();
        }
        int precision = this.parsePrecisionFromFormatStyle(formatStyle);
        boolean tailingFractionZeros = this.parseTailingFractionZerosFromFormatStyle(formatStyle);
        CharSequence charSequence = formatType;
        return Intrinsics.areEqual((Object)charSequence, (Object)FORMAT_STYLE_NUMBER) ? LocalizedStringNumber.Companion.formatNumber((Number)value, precision, tailingFractionZeros, locale) : (Intrinsics.areEqual((Object)charSequence, (Object)FORMAT_STYLE_LENGTH) ? (CharSequence)LocalizedStringNumber.Companion.getFormattedLength(((Number)value).doubleValue(), ((Number)value).doubleValue(), precision, tailingFractionZeros).toString(locale) : (Intrinsics.areEqual((Object)charSequence, (Object)FORMAT_STYLE_AREA) ? (CharSequence)LocalizedStringNumber.Companion.getFormattedArea(((Number)value).doubleValue(), ((Number)value).doubleValue(), precision, tailingFractionZeros).toString(locale) : (Intrinsics.areEqual((Object)charSequence, (Object)FORMAT_STYLE_WEIGHT) ? (CharSequence)LocalizedStringNumber.Companion.getFormattedWeight(((Number)value).doubleValue(), ((Number)value).doubleValue(), precision, tailingFractionZeros).toString(locale) : (Intrinsics.areEqual((Object)charSequence, (Object)FORMAT_STYLE_TIMESPAN) ? (CharSequence)LocalizedStringNumber.Companion.getFormattedTimeSpan(((Number)value).doubleValue()).toString(locale) : (CharSequence)value.toString()))));
    }

    private final int parsePrecisionFromFormatStyle(CharSequence formatStyle) {
        int n;
        if (formatStyle == null || !StringsKt.startsWith$default((CharSequence)formatStyle, (CharSequence)"%", (boolean)false, (int)2, null)) {
            return Integer.MAX_VALUE;
        }
        int idxStart = StringsKt.indexOf$default((CharSequence)formatStyle, (String)".", (int)0, (boolean)false, (int)6, null);
        if (idxStart < 0 || idxStart + 1 >= formatStyle.length()) {
            return Integer.MAX_VALUE;
        }
        int n2 = idxStart;
        idxStart = n2 + 1;
        int idxEnd = idxStart;
        if (formatStyle.charAt(idxEnd) == '-') {
            n = idxEnd;
            idxEnd = n + 1;
        }
        while (formatStyle.length() > idxEnd && LocalizedNumberStringKt.isDigit(formatStyle.charAt(idxEnd))) {
            n = idxEnd;
            idxEnd = n + 1;
        }
        Integer n3 = StringsKt.toIntOrNull((String)((Object)formatStyle.subSequence(idxStart, idxEnd)).toString());
        return n3 == null ? Integer.MAX_VALUE : n3;
    }

    private final boolean parseTailingFractionZerosFromFormatStyle(CharSequence formatStyle) {
        if (formatStyle == null || !StringsKt.startsWith$default((CharSequence)formatStyle, (CharSequence)"%", (boolean)false, (int)2, null)) {
            return false;
        }
        return StringsKt.contains$default((CharSequence)formatStyle, (CharSequence)".0", (boolean)false, (int)2, null);
    }
}

