/*
 * Decompiled with CFR 0.152.
 */
package de.cologneintelligence;

import de.cologneintelligence.StreamLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.util.JavaEnvUtils;

@Mojo(name="integration-test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class FitIntegrationTestMojo
extends AbstractMojo {
    public static final String FIT_MOJO_RESULT_FAILURE = "fit.mojo.result.failure";
    public static final String MAIN_CLASS = "de.cologneintelligence.fitgoodies.runners.FitRunner";
    @Parameter(defaultValue="target/fit", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="src/test/fixtures", property="fixturesDir", required=true)
    private File fixturesDirectory;
    @Parameter(property="limits", required=false)
    private String[] limits = new String[0];
    @Parameter(property="additionalClasspathElements", required=false)
    private File[] additionalClasspathElements = new File[0];
    @Parameter(property="forkJvmArgs", required=false)
    private String[] jvmArgs = new String[0];
    @Parameter(defaultValue="UTF-8", property="project.build.sourceEncoding", required=false)
    private String encoding;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Copy static resources into output directory");
        this.copyNonTestFiles(this.fixturesDirectory, this.outputDirectory);
        this.getLog().info((CharSequence)"Running Tests");
        URL[] classpath = this.createClasspath();
        this.runFit(classpath);
    }

    private void copyNonTestFiles(File sourceDir, File targetDir) throws MojoExecutionException {
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    File newTarget = new File(targetDir, file.getName());
                    newTarget.mkdirs();
                    this.copyNonTestFiles(file, newTarget);
                    continue;
                }
                if (!this.isNonTestFile(file.getName())) continue;
                try {
                    FileUtils.copyFile((File)file, (File)new File(targetDir, file.getName()));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy file: " + file.getAbsolutePath(), (Exception)e);
                }
            }
        }
    }

    private boolean isNonTestFile(String name) {
        return !name.matches("(?i).*\\.html?$");
    }

    private URL[] createClasspath() throws MojoExecutionException {
        List<String> classpathElements = this.getClasspath();
        classpathElements.add(this.project.getBuild().getOutputDirectory());
        classpathElements.add(this.project.getBuild().getTestOutputDirectory());
        URL[] urls = new URL[classpathElements.size()];
        for (int i = 0; i < classpathElements.size(); ++i) {
            File file = new File(classpathElements.get(i));
            try {
                urls[i] = file.toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Could not build classpath with '" + file + "'", (Exception)e);
            }
        }
        return urls;
    }

    private List<String> getClasspath() throws MojoExecutionException {
        try {
            List temp = this.project.getTestClasspathElements();
            return temp;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not determine runtime classpath", (Exception)((Object)e));
        }
    }

    private void saveResult(boolean result) {
        Map context = this.getPluginContext();
        context.put(FIT_MOJO_RESULT_FAILURE, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFit(URL[] classpath) throws MojoExecutionException, MojoFailureException {
        File bootJar;
        try {
            bootJar = this.writeBootJar(this.createClassPathString(classpath));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write boot jar", (Exception)e);
        }
        try {
            ProcessBuilder builder = this.prepareProcess(bootJar);
            this.startProcess(builder);
        }
        finally {
            bootJar.delete();
        }
    }

    private void startProcess(ProcessBuilder builder) throws MojoExecutionException {
        try {
            Process process = builder.start();
            new StreamLogger(process.getErrorStream(), true, this.getLog()).start();
            new StreamLogger(process.getInputStream(), false, this.getLog()).start();
            int result = process.waitFor();
            boolean success = result == 0;
            this.saveResult(success);
            if (success) {
                this.getLog().info((CharSequence)("One or more fit test(s) failed with return code " + result + ". Will fail in verify phase!"));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while running fit", e);
        }
    }

    private ProcessBuilder prepareProcess(File bootJar) throws MojoExecutionException {
        try {
            String executable = JavaEnvUtils.getJreExecutable((String)"java");
            List<String> args = this.createJavaArgs(executable, bootJar);
            this.getLog().debug((CharSequence)("Running process: " + args.toString()));
            return new ProcessBuilder(args).directory(this.project.getBasedir());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while preparing java process", e);
        }
    }

    private List<String> createJavaArgs(String executable, File bootJar) throws URISyntaxException {
        LinkedList<String> args = new LinkedList<String>();
        args.add(executable);
        args.add("-cp");
        args.add(bootJar.getAbsolutePath());
        args.addAll(Arrays.asList(this.jvmArgs));
        args.add(MAIN_CLASS);
        args.add("-d");
        args.add(this.outputDirectory.getPath());
        args.add("-e");
        args.add(this.encoding);
        args.add("-s");
        args.add(this.fixturesDirectory.getPath());
        for (String limit : this.limits) {
            args.add("-o");
            args.add(limit);
        }
        return args;
    }

    private String createClassPathString(URL[] classpath) {
        StringBuilder classPathBuilder = new StringBuilder();
        for (URL uRL : classpath) {
            this.appendToClasspath(uRL, classPathBuilder);
        }
        for (Serializable serializable : this.additionalClasspathElements) {
            try {
                this.appendToClasspath(((File)serializable).toURI().toURL(), classPathBuilder);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Cannot convert file to url: " + serializable, e);
            }
        }
        return classPathBuilder.toString();
    }

    private void appendToClasspath(URL url, StringBuilder classPathBuilder) {
        if (classPathBuilder.length() > 0) {
            classPathBuilder.append(' ');
        }
        classPathBuilder.append(url.toString());
    }

    public File writeBootJar(String classpath) throws IOException {
        File bootJar = new File(this.outputDirectory, "boot.jar");
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classpath);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(bootJar), manifest);
        jarOutputStream.close();
        return bootJar;
    }
}

