/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;

public class DoubleComparators {
    public static final DoubleComparator NATURAL_COMPARATOR = new AbstractDoubleComparator(){

        @Override
        public final int compare(double a, double b) {
            return Double.compare(a, b);
        }
    };
    public static final DoubleComparator OPPOSITE_COMPARATOR = new AbstractDoubleComparator(){

        @Override
        public final int compare(double a, double b) {
            return -Double.compare(a, b);
        }
    };

    private DoubleComparators() {
    }

    public static DoubleComparator oppositeComparator(final DoubleComparator c) {
        return new AbstractDoubleComparator(){
            private final DoubleComparator comparator;
            {
                this.comparator = c;
            }

            @Override
            public final int compare(double a, double b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

