/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.parquet.serializer;

import de.codepfleger.flume.avro.serializer.event.SyslogEvent;
import de.codepfleger.flume.avro.serializer.serializer.AbstractReflectionAvroEventSerializer;
import de.codepfleger.flume.parquet.serializer.AbstractParquetSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.serialization.EventSerializer;
import org.apache.flume.source.SyslogParser;

public class SyslogSerializer
extends AbstractParquetSerializer {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final SyslogParser syslogParser = new SyslogParser();

    public SyslogSerializer() {
        super(new Schema.Parser().parse(AbstractReflectionAvroEventSerializer.createSchema(SyslogEvent.class)));
    }

    public void write(Event flumeEvent) throws IOException {
        try {
            String syslogMessage = new String(flumeEvent.getBody());
            Event event = this.syslogParser.parseMessage(syslogMessage, Charset.defaultCharset(), null);
            LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : event.getHeaders().entrySet()) {
                if ("timestamp".equals(entry.getKey())) {
                    dataMap.put((String)entry.getKey(), DATE_FORMAT.format(new Date(Long.parseLong((String)entry.getValue()))));
                    continue;
                }
                dataMap.put((String)entry.getKey(), entry.getValue());
            }
            dataMap.put("Message", new String(event.getBody()));
            SyslogEvent syslogEvent = new SyslogEvent();
            AbstractReflectionAvroEventSerializer.setFieldsAndRemove(syslogEvent, dataMap);
            syslogEvent.dynamic.putAll(dataMap);
            GenericData.Record record = new GenericData.Record(this.getSchema());
            record.put("Severity", (Object)syslogEvent.Severity);
            record.put("Facility", (Object)syslogEvent.Facility);
            record.put("host", (Object)syslogEvent.host);
            record.put("timestamp", (Object)syslogEvent.timestamp);
            record.put("Message", (Object)syslogEvent.Message);
            record.put("dynamic", syslogEvent.dynamic);
            this.writeRecord(record);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Builder
    implements EventSerializer.Builder {
        public EventSerializer build(Context context, OutputStream out) {
            SyslogSerializer writer = new SyslogSerializer();
            writer.configure(context);
            return writer;
        }
    }
}

