/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.parquet.serializer;

import de.codepfleger.flume.parquet.serializer.ParquetSerializer;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.flume.Context;
import org.apache.parquet.hadoop.ParquetWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParquetSerializer
implements ParquetSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractParquetSerializer.class);
    private ParquetWriter<GenericData.Record> writer;
    private Schema schema;

    protected AbstractParquetSerializer(Schema schema) {
        this.schema = schema;
    }

    public void configure(Context context) {
    }

    public void afterCreate() throws IOException {
    }

    public void afterReopen() throws IOException {
    }

    protected synchronized void writeRecord(GenericData.Record record) throws IOException {
        this.writer.write(record);
    }

    public void flush() throws IOException {
    }

    public void beforeClose() throws IOException {
        this.writer.close();
    }

    public boolean supportsReopen() {
        return false;
    }

    @Override
    public void initialize(ParquetWriter<GenericData.Record> writer) throws IOException {
        this.writer = writer;
    }

    @Override
    public ParquetWriter<GenericData.Record> getWriter() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        this.beforeClose();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }
}

