/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.avro.serializer.utils;

import de.codepfleger.flume.avro.serializer.converter.Converter;
import de.codepfleger.flume.avro.serializer.converter.IntegerConverter;
import de.codepfleger.flume.avro.serializer.converter.LongConverter;
import de.codepfleger.flume.avro.serializer.converter.StringConverter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;

public class DynamicAvroSchemaCreator {
    private final Map<Class, Converter> convertersMap = new LinkedHashMap<Class, Converter>();

    public DynamicAvroSchemaCreator() {
        this.convertersMap.put(Integer.class, new IntegerConverter());
        this.convertersMap.put(Long.class, new LongConverter());
        this.convertersMap.put(String.class, new StringConverter());
    }

    public Schema createSchema(Map<String, Object> data) throws Exception {
        List<Schema.Field> fields = this.createFields(data);
        Schema schema = Schema.createRecord("Event", null, null, false);
        Method method = schema.getClass().getDeclaredMethod("setFields", List.class);
        method.setAccessible(true);
        method.invoke((Object)schema, fields);
        return schema;
    }

    private List<Schema.Field> createFields(Map<String, Object> data) throws IOException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            ArrayList<Schema> types = new ArrayList<Schema>();
            types.add(Schema.create(Schema.Type.NULL));
            types.add(Schema.create(this.deduceType(entry)));
            Schema typeSchema = Schema.createUnion(types);
            Schema.Field field = new Schema.Field(entry.getKey(), typeSchema, null, null, Schema.Field.Order.ASCENDING);
            fields.add(field);
        }
        return fields;
    }

    public Schema.Type deduceType(Map.Entry<String, Object> entry) {
        Object typed = this.getTypedObject(entry.getValue());
        for (Converter converter : this.convertersMap.values()) {
            Schema.Type type = converter.convertToType(typed);
            if (type == null) continue;
            return type;
        }
        throw new IllegalStateException("Unmappable type: " + typed);
    }

    public Object getTypedObject(Object untyped) {
        for (Converter converter : this.convertersMap.values()) {
            try {
                Object typed = converter.convertToTypedObject(untyped);
                return typed;
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException("Unmappable type: " + untyped);
    }

    public <T> T convertByType(Class<T> type, Object untyped) throws Exception {
        Converter converter = this.convertersMap.get(type);
        return converter.convertToTypedObject(untyped);
    }
}

