/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.parquet.sink;

import de.codepfleger.flume.parquet.serializer.ParquetSerializer;
import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SerializerMapEntry {
    private Path workingPath;
    private Configuration configuration;
    private String targetPath;
    private ParquetSerializer serializer;
    private long startTime;

    public SerializerMapEntry(Path workingPath, Configuration configuration, String targetPath, ParquetSerializer serializer) {
        this.workingPath = workingPath;
        this.configuration = configuration;
        this.targetPath = targetPath;
        this.serializer = serializer;
        this.startTime = new Date().getTime();
    }

    public ParquetSerializer getSerializer() {
        return this.serializer;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void close() throws IOException {
        this.serializer.close();
        FileSystem fileSystem = this.workingPath.getFileSystem(this.configuration);
        Path dstPath = new Path(this.targetPath);
        fileSystem.rename(this.workingPath, dstPath);
    }
}

