/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.parquet.sink;

import de.codepfleger.flume.parquet.sink.SerializerMapEntry;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerLinkedHashMap
extends LinkedHashMap<String, SerializerMapEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(SerializerLinkedHashMap.class);
    private final int maxOpenFiles;

    public SerializerLinkedHashMap(int maxOpenFiles) {
        super(maxOpenFiles, 0.75f, true);
        this.maxOpenFiles = maxOpenFiles;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, SerializerMapEntry> eldest) {
        if (this.size() > this.maxOpenFiles) {
            try {
                eldest.getValue().close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return true;
        }
        return false;
    }
}

