/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.parquet.serializer;

import de.codepfleger.flume.avro.serializer.event.WindowsLogEvent;
import de.codepfleger.flume.avro.serializer.serializer.AbstractReflectionAvroEventSerializer;
import de.codepfleger.flume.parquet.serializer.AbstractParquetSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.serialization.EventSerializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsLogSerializer
extends AbstractParquetSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsLogSerializer.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public WindowsLogSerializer() {
        super(new Schema.Parser().parse(AbstractReflectionAvroEventSerializer.createSchema(WindowsLogEvent.class)));
    }

    public void write(Event event) throws IOException {
        try {
            String message = new String(event.getBody());
            LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>((Map)this.mapper.readValue(message, Map.class));
            WindowsLogEvent windowsLogEvent = new WindowsLogEvent();
            AbstractReflectionAvroEventSerializer.setFieldsAndRemove(windowsLogEvent, dataMap);
            windowsLogEvent.dynamic.putAll(dataMap);
            GenericData.Record record = new GenericData.Record(this.getSchema());
            record.put("EventTime", (Object)windowsLogEvent.EventTime);
            record.put("Hostname", (Object)windowsLogEvent.Hostname);
            record.put("EventType", (Object)windowsLogEvent.EventType);
            record.put("Severity", (Object)windowsLogEvent.Severity);
            record.put("SourceModuleName", (Object)windowsLogEvent.SourceModuleName);
            record.put("UserID", (Object)windowsLogEvent.UserID);
            record.put("ProcessID", (Object)windowsLogEvent.ProcessID);
            record.put("Domain", (Object)windowsLogEvent.Domain);
            record.put("EventReceivedTime", (Object)windowsLogEvent.EventReceivedTime);
            record.put("Path", (Object)windowsLogEvent.Path);
            record.put("Message", (Object)windowsLogEvent.Message);
            record.put("dynamic", windowsLogEvent.dynamic);
            this.writeRecord(record);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Builder
    implements EventSerializer.Builder {
        public EventSerializer build(Context context, OutputStream out) {
            WindowsLogSerializer writer = new WindowsLogSerializer();
            writer.configure(context);
            return writer;
        }
    }
}

