/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.avro.serializer.serializer;

import de.codepfleger.flume.avro.serializer.event.WindowsLogEvent;
import de.codepfleger.flume.avro.serializer.serializer.AbstractReflectionAvroEventSerializer;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.serialization.EventSerializer;
import org.codehaus.jackson.map.ObjectMapper;

public class WindowsLogSerializer
extends AbstractReflectionAvroEventSerializer<WindowsLogEvent> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final OutputStream out;

    public WindowsLogSerializer(OutputStream out) {
        this.out = out;
    }

    protected Schema getSchema() {
        return new Schema.Parser().parse(WindowsLogSerializer.createSchema(WindowsLogEvent.class));
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    protected WindowsLogEvent convert(Event event) {
        try {
            String message = new String(event.getBody());
            LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>((Map)this.mapper.readValue(message, Map.class));
            WindowsLogEvent windowsLogEvent = new WindowsLogEvent();
            WindowsLogSerializer.setFieldsAndRemove(windowsLogEvent, dataMap);
            windowsLogEvent.dynamic.putAll(dataMap);
            return windowsLogEvent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Builder
    implements EventSerializer.Builder {
        public EventSerializer build(Context context, OutputStream out) {
            WindowsLogSerializer writer = new WindowsLogSerializer(out);
            writer.configure(context);
            return writer;
        }
    }
}

