/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.avro.serializer.serializer;

import de.codepfleger.flume.avro.serializer.event.SyslogEvent;
import de.codepfleger.flume.avro.serializer.serializer.AbstractReflectionAvroEventSerializer;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.serialization.EventSerializer;
import org.apache.flume.source.SyslogParser;

public class SyslogSerializer
extends AbstractReflectionAvroEventSerializer<SyslogEvent> {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final SyslogParser syslogParser;
    private final OutputStream out;

    public SyslogSerializer(OutputStream out) {
        this.out = out;
        this.syslogParser = new SyslogParser();
    }

    protected Schema getSchema() {
        return new Schema.Parser().parse(SyslogSerializer.createSchema(SyslogEvent.class));
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    protected SyslogEvent convert(Event event) {
        try {
            String syslogMessage = new String(event.getBody());
            Event syslogEvent = this.syslogParser.parseMessage(syslogMessage, Charset.defaultCharset(), null);
            LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : syslogEvent.getHeaders().entrySet()) {
                if ("timestamp".equals(entry.getKey())) {
                    dataMap.put((String)entry.getKey(), DATE_FORMAT.format(new Date(Long.parseLong((String)entry.getValue()))));
                    continue;
                }
                dataMap.put((String)entry.getKey(), entry.getValue());
            }
            dataMap.put("Message", new String(syslogEvent.getBody()));
            SyslogEvent unixEvent = new SyslogEvent();
            SyslogSerializer.setFieldsAndRemove(unixEvent, dataMap);
            unixEvent.dynamic.putAll(dataMap);
            return unixEvent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Builder
    implements EventSerializer.Builder {
        public EventSerializer build(Context context, OutputStream out) {
            SyslogSerializer writer = new SyslogSerializer(out);
            writer.configure(context);
            return writer;
        }
    }
}

