/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.avro.serializer.serializer;

import de.codepfleger.flume.avro.serializer.serializer.AbstractDynamicAvroSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.serialization.EventSerializer;
import org.apache.flume.source.SyslogParser;

public class DynamicSyslogSerializer
extends AbstractDynamicAvroSerializer {
    private final SyslogParser syslogParser = new SyslogParser();

    public DynamicSyslogSerializer(OutputStream out) {
        super(out);
    }

    protected Map getOrderedData(Event event) throws IOException {
        String syslogMessage = new String(event.getBody());
        Event syslogEvent = this.syslogParser.parseMessage(syslogMessage, Charset.defaultCharset(), null);
        LinkedHashMap data = new LinkedHashMap();
        for (Map.Entry entry : syslogEvent.getHeaders().entrySet()) {
            data.put(entry.getKey(), this.schemaCreator.getTypedObject(entry.getValue()));
        }
        data.put("message", new String(syslogEvent.getBody()));
        return data;
    }

    public static class Builder
    implements EventSerializer.Builder {
        public EventSerializer build(Context context, OutputStream out) {
            DynamicSyslogSerializer serializer = new DynamicSyslogSerializer(out);
            serializer.configure(context);
            return serializer;
        }
    }
}

