/*
 * Decompiled with CFR 0.152.
 */
package de.codepfleger.flume.avro.serializer.serializer;

import de.codepfleger.flume.avro.serializer.utils.DynamicAvroSchemaCreator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.Configurable;
import org.apache.flume.serialization.AbstractAvroEventSerializer;
import org.apache.flume.serialization.EventSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicAvroSerializer
implements EventSerializer,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAvroEventSerializer.class);
    private final OutputStream out;
    protected final DynamicAvroSchemaCreator schemaCreator;
    private Integer syncIntervalBytes;
    private String compressionCodec;

    public AbstractDynamicAvroSerializer(OutputStream out) {
        this.out = out;
        this.schemaCreator = new DynamicAvroSchemaCreator();
    }

    protected abstract Map<String, Object> getOrderedData(Event var1) throws IOException;

    public void configure(Context context) {
        this.syncIntervalBytes = context.getInteger("syncIntervalBytes", Integer.valueOf(2048000));
        this.compressionCodec = context.getString("compressionCodec", "null");
    }

    public void afterCreate() throws IOException {
    }

    public void afterReopen() throws IOException {
        throw new UnsupportedOperationException("Avro API doesn't support append");
    }

    public void write(Event event) throws IOException {
        try {
            Map<String, Object> orderedData = this.getOrderedData(event);
            ArrayList<Object> orderedList = new ArrayList<Object>(orderedData.values());
            Schema schema = this.schemaCreator.createSchema(orderedData);
            GenericRecord record = this.createGenericRecord(orderedData, orderedList, schema);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)writer);
            dataFileWriter.setSyncInterval(this.syncIntervalBytes.intValue());
            try {
                CodecFactory codecFactory = CodecFactory.fromString((String)this.compressionCodec);
                dataFileWriter.setCodec(codecFactory);
            }
            catch (AvroRuntimeException e) {
                LOGGER.warn("Unable to instantiate avro codec with name (" + this.compressionCodec + "). Compression disabled. Exception follows.", (Throwable)e);
            }
            dataFileWriter.create(schema, this.out);
            dataFileWriter.append((Object)record);
            dataFileWriter.flush();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private GenericRecord createGenericRecord(final Map<String, Object> orderedData, final List<Object> orderedList, final Schema schema) {
        return new GenericRecord(){

            public Schema getSchema() {
                return schema;
            }

            public void put(int i, Object v) {
            }

            public Object get(int index) {
                return orderedList.get(index);
            }

            public void put(String key, Object v) {
            }

            public Object get(String key) {
                return orderedData.get(key);
            }
        };
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void beforeClose() throws IOException {
    }

    public boolean supportsReopen() {
        return false;
    }
}

