/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui.impl.textinput;

import de.placeblock.betterinventories.content.item.GUIButton;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.gui.PlayerGUI;
import de.placeblock.betterinventories.gui.impl.BaseAnvilGUI;
import de.placeblock.betterinventories.gui.impl.textinput.FinishConsumer;
import de.placeblock.betterinventories.nms.TextInputPacketListener;
import de.placeblock.betterinventories.util.ItemBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TextInputGUI
extends BaseAnvilGUI
implements PlayerGUI<Player> {
    public static final Material INPUT_MATERIAL = Material.PAPER;
    public static final Material RESULT_MATERIAL = Material.LIME_DYE;
    private final Player player;
    private final TextInputPacketListener packetListener;
    private final FinishConsumer onFinish;
    private final Consumer<String> onUpdate;
    private final Function<String, TextComponent> titleConverter;
    private String currentText;
    private boolean closed = false;

    protected TextInputGUI(Plugin plugin, TextComponent title, boolean removeItems, Player player, String text, FinishConsumer onFinish, Consumer<String> onUpdate, Function<String, TextComponent> titleConverter) {
        super(plugin, title, removeItems);
        this.player = player;
        this.currentText = text;
        this.onFinish = onFinish;
        this.onUpdate = onUpdate;
        this.titleConverter = titleConverter;
        this.setInputItem();
        this.setResultButton();
        this.update();
        this.packetListener = GUI.NMS_BRIDGE.getTextInputPacketListener(this.player, this::updateText);
        this.packetListener.register();
    }

    private void setInputItem() {
        TextComponent title = Component.text((String)this.currentText);
        ItemStack inputItem = new ItemBuilder(title, INPUT_MATERIAL).build();
        GUIButton inputButton = ((GUIButton.Builder)new GUIButton.Builder(this).itemStack(inputItem)).build();
        this.setInputItem(inputButton);
    }

    private void setResultButton() {
        TextComponent title = this.titleConverter.apply(this.currentText);
        ItemStack resultItem = new ItemBuilder(title, RESULT_MATERIAL).build();
        GUIButton resultButton = ((GUIButton.Builder)((GUIButton.Builder)new GUIButton.Builder(this).itemStack(resultItem)).onClick(cd -> this.finish(false))).build();
        this.setResultItem(resultButton);
    }

    public void updateText(String text) {
        if (this.onUpdate != null) {
            this.onUpdate.accept(text);
        }
        this.onUpdate(text);
        this.currentText = text;
        this.setResultButton();
        this.update();
    }

    @Override
    public void onClose(Player player) {
        this.finish(true);
        super.onClose(player);
    }

    private void finish(boolean abort) {
        if (this.onFinish == null || this.onFinish.accept(this.currentText, abort) && this.onFinish(this.currentText, abort) || abort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.packetListener.unregister();
            this.player.closeInventory();
        } else {
            Bukkit.getScheduler().runTaskLater(this.getPlugin(), () -> {
                this.setInputItem();
                this.update();
            }, 1L);
        }
    }

    public void onUpdate(String text) {
    }

    public boolean onFinish(String text, boolean abort) {
        return true;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public static class Builder<P extends JavaPlugin>
    extends AbstractBuilder<Builder<P>, TextInputGUI, P> {
        public Builder(P plugin, Player player) {
            super(plugin, player);
        }

        @Override
        public TextInputGUI build() {
            return new TextInputGUI((Plugin)this.getPlugin(), this.getTitle(), this.isRemoveItems(), this.getPlayer(), this.getText(), this.getOnFinish(), this.getOnUpdate(), this.getTitleConverter());
        }

        @Override
        protected Builder<P> self() {
            return this;
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, G, P>, G extends TextInputGUI, P extends JavaPlugin>
    extends BaseAnvilGUI.AbstractBuilder<B, G, P> {
        private final Player player;
        private String text = "";
        private FinishConsumer onFinish = (t, a) -> false;
        private Consumer<String> onUpdate = t -> {};
        private Function<String, TextComponent> titleConverter = Component::text;

        public AbstractBuilder(P plugin, Player player) {
            super(plugin);
            this.player = player;
        }

        public B text(String text) {
            this.text = text;
            return (B)((AbstractBuilder)this.self());
        }

        public B onFinish(FinishConsumer onFinish) {
            this.onFinish = onFinish;
            return (B)((AbstractBuilder)this.self());
        }

        public B onUpdate(Consumer<String> onUpdate) {
            this.onUpdate = onUpdate;
            return (B)((AbstractBuilder)this.self());
        }

        public B titleConverter(Function<String, TextComponent> titleConverter) {
            this.titleConverter = titleConverter;
            return (B)((AbstractBuilder)this.self());
        }

        @Generated
        protected Player getPlayer() {
            return this.player;
        }

        @Generated
        protected String getText() {
            return this.text;
        }

        @Generated
        protected FinishConsumer getOnFinish() {
            return this.onFinish;
        }

        @Generated
        protected Consumer<String> getOnUpdate() {
            return this.onUpdate;
        }

        @Generated
        protected Function<String, TextComponent> getTitleConverter() {
            return this.titleConverter;
        }
    }
}

