/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui.impl;

import de.placeblock.betterinventories.content.SearchData;
import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.gui.GUI;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BaseAnvilGUI
extends GUI {
    private GUIItem inputItem;
    private GUIItem additionalItem;
    private GUIItem resultItem;

    protected BaseAnvilGUI(Plugin plugin, TextComponent title, boolean removeItems) {
        super(plugin, title, InventoryType.ANVIL, removeItems);
    }

    @Override
    public Inventory createBukkitInventory() {
        return Bukkit.createInventory(null, (InventoryType)InventoryType.ANVIL, (Component)this.getTitle());
    }

    @Override
    public int getSlots() {
        return 3;
    }

    @Override
    public List<ItemStack> renderContent() {
        ItemStack inputItem = this.inputItem == null ? null : this.inputItem.getItemStack();
        ItemStack additionalItem = this.additionalItem == null ? null : this.additionalItem.getItemStack();
        ItemStack resultItem = this.resultItem == null ? null : this.resultItem.getItemStack();
        return Arrays.asList(inputItem, additionalItem, resultItem);
    }

    @Override
    public void searchSection(SearchData searchData) {
        switch (searchData.getSlot()) {
            case 0: {
                if (this.inputItem == null) break;
                this.inputItem.search(searchData);
                break;
            }
            case 1: {
                if (this.additionalItem == null) break;
                this.additionalItem.search(searchData);
                break;
            }
            case 2: {
                if (this.resultItem == null) break;
                this.resultItem.search(searchData);
            }
        }
    }

    @Override
    public void provideItem(ItemStack itemStack) {
    }

    @Generated
    public GUIItem getInputItem() {
        return this.inputItem;
    }

    @Generated
    public GUIItem getAdditionalItem() {
        return this.additionalItem;
    }

    @Generated
    public GUIItem getResultItem() {
        return this.resultItem;
    }

    @Generated
    public void setInputItem(GUIItem inputItem) {
        this.inputItem = inputItem;
    }

    @Generated
    public void setAdditionalItem(GUIItem additionalItem) {
        this.additionalItem = additionalItem;
    }

    @Generated
    public void setResultItem(GUIItem resultItem) {
        this.resultItem = resultItem;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, G, P>, G extends BaseAnvilGUI, P extends JavaPlugin>
    extends GUI.Builder<B, G, P> {
        private GUIItem inputItem;
        private GUIItem additionalItem;
        private GUIItem resultItem;

        public B inputItem(GUIItem item) {
            this.inputItem = item;
            return (B)((AbstractBuilder)this.self());
        }

        public B additionalItem(GUIItem item) {
            this.additionalItem = item;
            return (B)((AbstractBuilder)this.self());
        }

        public B resultItem(GUIItem item) {
            this.resultItem = item;
            return (B)((AbstractBuilder)this.self());
        }

        public AbstractBuilder(P plugin) {
            super(plugin);
        }

        @Generated
        protected GUIItem getInputItem() {
            return this.inputItem;
        }

        @Generated
        protected GUIItem getAdditionalItem() {
            return this.additionalItem;
        }

        @Generated
        protected GUIItem getResultItem() {
            return this.resultItem;
        }
    }
}

