/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl.simple;

import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.SearchData;
import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.content.pane.GUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;

public abstract class BaseSimpleGUIPane<C extends GUISection, S extends BaseSimpleGUIPane<C, S>>
extends GUIPane {
    protected final List<ChildData<C>> content = new ArrayList<ChildData<C>>();
    protected final boolean autoSize;

    protected BaseSimpleGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize, boolean autoSize) {
        super(gui, minSize, maxSize);
        this.autoSize = autoSize;
    }

    @Override
    public void updateSizeRecursive(Sizeable parent) {
        this.updateChildrenRecursive(parent);
        this.updateSize(parent);
    }

    @Override
    public void updateSize(Sizeable parent) {
        if (this.autoSize) {
            HashSet<Vector2d> vectors = new HashSet<Vector2d>();
            for (ChildData<C> childData : this.content) {
                vectors.add(childData.getPosition().add(((GUISection)childData.getChild()).getSize()));
            }
            this.setSize(Vector2d.largest(vectors));
        }
    }

    @Override
    public List<GUISection> getChildren() {
        return this.content.stream().map(ChildData::getChild).collect(Collectors.toList());
    }

    @Override
    public void onItemProvide(ItemStack item) {
    }

    @Override
    public List<ItemStack> render() {
        List<ItemStack> content = this.getEmptyContentList(ItemStack.class);
        if (!content.isEmpty()) {
            for (ChildData<C> childData : this.content) {
                this.renderOnList((GUISection)childData.getChild(), childData.getPosition(), content);
            }
        }
        return content;
    }

    @Override
    public void search(SearchData searchData) {
        for (int i = this.content.size() - 1; i >= 0; --i) {
            ChildData<C> childData = this.content.get(i);
            Vector2d pos = childData.getPosition();
            Vector2d relativePos = searchData.getRelativePos();
            C section = childData.getChild();
            if (!searchData.getPredicate().test(section) || pos.getX() > relativePos.getX() || pos.getX() + ((GUISection)section).getWidth() - 1 < relativePos.getX() || pos.getY() > relativePos.getY() || pos.getY() + ((GUISection)section).getHeight() - 1 < relativePos.getY()) continue;
            searchData.addNode(this);
            searchData.setRelativePos(relativePos.subtract(pos));
            ((GUISection)section).search(searchData);
            return;
        }
        searchData.setSection(this);
    }

    public S addItemEmptySlot(GUIItem item) {
        int nextEmptySlot = this.getNextEmptySlot();
        if (nextEmptySlot == -1) {
            return (S)this;
        }
        this.setSectionAt(nextEmptySlot, item);
        return (S)this;
    }

    public S fill(GUIItem item) {
        while (this.getNextEmptySlot() != -1) {
            this.addItemEmptySlot(item);
        }
        return (S)this;
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.getSlots(); ++i) {
            SearchData searchData = new SearchData(i, s -> true);
            searchData.setRelativePos(this.slotToVector(i));
            this.search(searchData);
            if (!this.equals(searchData.getSection())) continue;
            return i;
        }
        return -1;
    }

    public boolean removeSection(C section) {
        ChildData<C> removal = null;
        for (ChildData<C> childData : this.content) {
            if (!childData.getChild().equals(section)) continue;
            removal = childData;
        }
        if (removal != null) {
            this.content.remove(removal);
            return true;
        }
        return false;
    }

    public boolean removeSection(Vector2d position) {
        return this.content.removeIf(childData -> childData.getPosition().equals(position));
    }

    public S clear() {
        this.content.clear();
        return (S)this;
    }

    public S setSectionAt(int slot, C section) {
        return this.setSectionAt(this.slotToVector(slot), section);
    }

    public S setSectionAt(Vector2d position, C section) {
        if (section == null) {
            this.removeSection(position);
        } else {
            this.content.add(new ChildData<C>(position, section));
        }
        return (S)this;
    }

    public S setSection(C section) {
        return this.setSectionAt(new Vector2d(), section);
    }

    public Collection<C> getSections(Vector2d position) {
        ArrayList sections = new ArrayList();
        for (ChildData<C> childData : this.content) {
            if (!childData.getPosition().equals(position)) continue;
            sections.add(childData.child);
        }
        return sections;
    }

    protected static class ChildData<C extends GUISection> {
        private Vector2d position;
        private final C child;

        @Generated
        public Vector2d getPosition() {
            return this.position;
        }

        @Generated
        public C getChild() {
            return this.child;
        }

        @Generated
        public ChildData(Vector2d position, C child) {
            this.position = position;
            this.child = child;
        }

        @Generated
        public void setPosition(Vector2d position) {
            this.position = position;
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, P, C>, P extends BaseSimpleGUIPane<C, P>, C extends GUISection>
    extends GUISection.AbstractBuilder<B, P> {
        private boolean autoSize = true;

        protected AbstractBuilder(GUI gui) {
            super(gui);
        }

        public B autoSize(boolean autoSize) {
            this.autoSize = autoSize;
            return (B)this;
        }

        protected boolean isAutoSize() {
            return this.autoSize;
        }
    }
}

