/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl.io;

import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.content.pane.impl.io.IOConsumer;
import de.placeblock.betterinventories.content.pane.impl.simple.BaseSimpleItemGUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Vector2d;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BaseIOGUIPane<S extends BaseIOGUIPane<S>>
extends BaseSimpleItemGUIPane<S> {
    private final boolean input;
    private final boolean output;
    private final boolean removeItemsOnInventoryClose;
    private final IOConsumer onItemChange;

    protected BaseIOGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize, boolean autoSize, boolean input, boolean output, boolean removeItemsOnInventoryClose, IOConsumer onItemChange) {
        super(gui, minSize, maxSize, autoSize);
        this.input = input;
        this.output = output;
        this.removeItemsOnInventoryClose = removeItemsOnInventoryClose;
        this.onItemChange = onItemChange;
    }

    @Override
    public boolean onItemAdd(Vector2d position, ItemStack itemStack) {
        if (!this.input) {
            return true;
        }
        this.setSectionAt(position, ((GUIItem.Builder)new GUIItem.Builder(this.getGui()).itemStack(itemStack)).build());
        Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), () -> {
            this.onItemChange(position, itemStack);
            this.getGui().update();
        }, 1L);
        return false;
    }

    @Override
    public ItemStack onItemRemove(Vector2d position) {
        if (!this.output) {
            return null;
        }
        return this.removeItem(position);
    }

    @Override
    public ItemStack onItemRemoveTroughInventoryClose(Vector2d position) {
        if (!this.removeItemsOnInventoryClose) {
            return null;
        }
        return this.removeItem(position);
    }

    @Nullable
    private ItemStack removeItem(Vector2d position) {
        GUIItem item = this.getItem(position);
        boolean removed = this.removeSection(item);
        if (removed) {
            Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), () -> {
                this.onItemChange(position, null);
                this.getGui().update();
            }, 1L);
            return item.getItemStack();
        }
        return null;
    }

    @Override
    public boolean onItemAmount(Vector2d position, int amount) {
        GUIItem item = this.getItem(position);
        int oldAmount = item.getItemStack().getAmount();
        if (oldAmount < amount && !this.input || oldAmount > amount && !this.output) {
            return true;
        }
        item.getItemStack().setAmount(amount);
        Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), () -> {
            this.onItemChange(position, item.getItemStack());
            this.getGui().update();
        }, 1L);
        return false;
    }

    @Override
    public void onItemProvide(ItemStack itemStack) {
        if (!this.input) {
            return;
        }
        ItemStack itemClone = itemStack.clone();
        for (int slot = 0; slot < this.getSlots() && itemStack.getAmount() > 0; ++slot) {
            int accepted;
            Vector2d position = this.slotToVector(slot);
            GUIItem item = this.getItem(position);
            if (item != null) {
                ItemStack currentItemStack = item.getItemStack();
                int currentAmount = currentItemStack.getAmount();
                int maxStackSize = currentItemStack.getMaxStackSize();
                if (!currentItemStack.isSimilar(itemStack) || currentAmount >= maxStackSize) continue;
                accepted = Math.min(maxStackSize - currentAmount, itemStack.getAmount());
                currentItemStack.setAmount(accepted + currentAmount);
                this.onItemChange(position, currentItemStack);
            } else {
                accepted = Math.min(itemStack.getMaxStackSize(), itemStack.getAmount());
                ItemStack slotItem = itemClone.clone();
                slotItem.setAmount(accepted);
                this.setSectionAt(slot, ((GUIItem.Builder)new GUIItem.Builder(this.getGui()).itemStack(slotItem)).build());
                this.onItemChange(position, slotItem);
            }
            itemStack.setAmount(itemStack.getAmount() - accepted);
        }
        Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), () -> this.getGui().update(), 1L);
    }

    public void onItemChange(Vector2d position, ItemStack itemStack) {
        if (this.onItemChange != null) {
            this.onItemChange.apply(position, itemStack);
        }
    }

    public static abstract class Builder<B extends Builder<B, P>, P extends BaseIOGUIPane<P>>
    extends BaseSimpleItemGUIPane.AbstractBuilder<B, P> {
        private boolean input = true;
        private boolean output = true;
        private boolean removeItemsOnInventoryClose = true;
        private IOConsumer onChange = (p, i) -> {};

        public Builder(GUI gui) {
            super(gui);
        }

        public B input(boolean input) {
            this.input = input;
            return (B)((Builder)this.self());
        }

        public B output(boolean output) {
            this.output = output;
            return (B)((Builder)this.self());
        }

        public B removeItemsOnInventoryClose(boolean remove) {
            this.removeItemsOnInventoryClose = remove;
            return (B)((Builder)this.self());
        }

        public B onChange(IOConsumer onChange) {
            this.onChange = onChange;
            return (B)((Builder)this.self());
        }

        @Generated
        protected boolean isInput() {
            return this.input;
        }

        @Generated
        protected boolean isOutput() {
            return this.output;
        }

        @Generated
        protected boolean isRemoveItemsOnInventoryClose() {
            return this.removeItemsOnInventoryClose;
        }

        @Generated
        protected IOConsumer getOnChange() {
            return this.onChange;
        }
    }
}

